/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d;

import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.gui.j2d.BackgroundPainter;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class AchievementBoxFactory {
    private static final String FONT_NAME = "AntykwaTorunska";
    private static final String ACHIEVEMENT_IMAGE_FOLDER = "data/sprites/achievements/";
    private static final String BACKGROUND = "data/gui/banner_background.png";
    private static final int TOP_MARGIN = 2;
    private static final int SIDE_MARGIN = 20;
    private static final int BOTTOM_MARGIN = 25;
    private static final int IMAGE_PAD = 5;
    private static final Graphics2D graphics = new BufferedImage(1, 1, 1).createGraphics();

    public Sprite createAchievementBox(String string, String string2, String string3) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(32, 32, TransparencyMode.TRANSPARENCY);
        String string4 = ACHIEVEMENT_IMAGE_FOLDER + string3.toLowerCase(Locale.ENGLISH) + ".png";
        try {
            bufferedImage = ImageIO.read(DataLoader.getResourceAsStream(string4));
        }
        catch (IOException iOException) {
            Logger.getLogger(AchievementBoxFactory.class).error((Object)("Error loading achievement box image: " + string4), (Throwable)iOException);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(AchievementBoxFactory.class).error((Object)("Error loading achievement box image: " + string4), (Throwable)runtimeException);
        }
        String string5 = WtWindowManager.getInstance().getProperty("ui.logfont", FONT_NAME);
        Font font = new Font(string5, 0, 14);
        Font font2 = font.deriveFont(20.0f);
        Rectangle2D rectangle2D = font2.getStringBounds(string, graphics.getFontRenderContext());
        Rectangle2D rectangle2D2 = font.getStringBounds(string2, graphics.getFontRenderContext());
        int n = (int)Math.max(rectangle2D.getWidth(), rectangle2D2.getWidth()) + bufferedImage.getWidth();
        int n2 = (int)Math.max((double)bufferedImage.getHeight(), rectangle2D.getHeight() + rectangle2D2.getHeight());
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n += 45, n2 += 27, TransparencyMode.TRANSPARENCY);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setComposite(AlphaComposite.Src);
        BackgroundPainter backgroundPainter = new BackgroundPainter(BACKGROUND);
        backgroundPainter.paint(graphics2D, n, n2);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(font2);
        graphics2D.drawString(string, 25 + bufferedImage.getWidth(), 2 + (int)rectangle2D.getHeight());
        graphics2D.setFont(font);
        graphics2D.drawString(string2, 25 + bufferedImage.getWidth(), n2 - 25);
        int n3 = (n2 - 25 - bufferedImage.getHeight()) / 2 + 2;
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.drawImage((Image)bufferedImage, 20, n3, null);
        graphics2D.dispose();
        return new ImageSprite(bufferedImage2);
    }
}

