/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Creature;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.RPEntity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.List;
import java.util.Map;

class Creature2DView
extends RPEntity2DView<Creature> {
    Creature2DView() {
    }

    @Override
    protected void buildSprites(Map<Object, Sprite> map, Sprite sprite, int n, int n2) {
        this.width = n;
        this.height = n2;
        super.buildSprites(map, sprite, n, n2);
    }

    @Override
    protected Sprite getAnimationSprite() {
        String string = ((Creature)this.entity).getMetamorphosis();
        if (string == null) {
            string = this.getClassResourcePath();
        }
        ZoneInfo zoneInfo = ZoneInfo.get();
        return this.addShadow(SpriteStore.get().getModifiedSprite(this.translate(string), zoneInfo.getZoneColor(), zoneInfo.getColorMethod()));
    }

    @Override
    protected void reorderActions(List<String> list) {
        if (list.remove(ActionType.ATTACK.getRepresentation())) {
            list.add(0, ActionType.ATTACK.getRepresentation());
        }
    }

    @Override
    protected String translate(String string) {
        return "data/sprites/monsters/" + string + ".png";
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        } else if (object == Creature.PROP_METAMORPHOSIS) {
            this.representationChanged = true;
        }
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.ATTACK);
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.ATTACK;
    }
}

