/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.gui.LinearScalingModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class HealthBar
implements ChangeListener {
    private final int width;
    private final int height;
    private BufferedImage image;
    private final LinearScalingModel model;
    private volatile boolean needsRedraw = true;

    HealthBar(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.model = new LinearScalingModel(1.0, n - 2);
        this.model.addChangeListener(this);
    }

    int getHeight() {
        return this.height;
    }

    int getWidth() {
        return this.width;
    }

    void setHPRatio(double d) {
        this.model.setValue(d);
    }

    void draw(Graphics graphics, int n, int n2) {
        if (this.image == null) {
            this.image = new BufferedImage(this.width, this.height, 1);
        }
        if (this.needsRedraw) {
            this.needsRedraw = false;
            Graphics2D graphics2D = this.image.createGraphics();
            this.drawImage(graphics2D);
            graphics2D.dispose();
        }
        graphics.drawImage(this.image, n, n2, null);
    }

    private void drawImage(Graphics graphics) {
        graphics.setColor(Color.GRAY);
        graphics.fillRect(1, 1, this.width, this.height);
        graphics.setColor(this.determineColor());
        graphics.fillRect(1, 1, this.model.getRepresentation(), this.height - 2);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(0, 0, this.width - 1, this.height - 1);
    }

    private Color determineColor() {
        float f = (float)this.model.getValue();
        float f2 = Math.min((1.0f - f) * 2.0f, 1.0f);
        float f3 = Math.min(f * 2.0f, 1.0f);
        return new Color(f2, f3, 0.0f);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.needsRedraw = true;
    }
}

