/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.OutfitStore;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Player;
import games.stendhal.client.entity.StatusID;
import games.stendhal.client.entity.User;
import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.gui.j2d.Blend;
import games.stendhal.client.gui.j2d.entity.RPEntity2DView;
import games.stendhal.client.gui.j2d.entity.helpers.HorizontalAlignment;
import games.stendhal.client.gui.j2d.entity.helpers.VerticalAlignment;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.util.List;
import org.apache.log4j.Logger;

class Player2DView<T extends Player>
extends RPEntity2DView<T> {
    private static final Logger logger = Logger.getLogger(Player2DView.class);
    private static final Color ZOMBIE_COLOR = new Color(536576);
    private static final Sprite awaySprite;
    private static final Sprite grumpySprite;
    private static final Sprite skullSprite;
    private boolean ignored = false;

    public Player2DView() {
        this.titleDrawYOffset = 6;
        this.addIconManager(new RPEntity2DView.AbstractStatusIconManager((Object)Player.PROP_AWAY, awaySprite, HorizontalAlignment.RIGHT, VerticalAlignment.TOP){

            @Override
            boolean show(T t) {
                return ((Player)t).isAway();
            }
        });
        this.addIconManager(new RPEntity2DView.AbstractStatusIconManager((Object)Player.PROP_GRUMPY, grumpySprite, HorizontalAlignment.LEFT, VerticalAlignment.TOP){

            @Override
            boolean show(T t) {
                return ((Player)t).isGrumpy();
            }
        });
        this.addIconManager(new RPEntity2DView.AbstractStatusIconManager((Object)Player.PROP_PLAYER_KILLER, skullSprite, HorizontalAlignment.LEFT, VerticalAlignment.TOP){

            @Override
            boolean show(T t) {
                return ((Player)t).isBadBoy();
            }
        });
    }

    @Override
    protected void drawStatusBar(Graphics2D graphics2D, int n, int n2, int n3) {
        this.drawTitle(graphics2D, n, n2, n3);
        Composite composite = graphics2D.getComposite();
        if (this.ignored && !((Player)this.entity).isGhostMode()) {
            graphics2D.setComposite(AlphaComposite.SrcAtop);
            this.drawHPbar(graphics2D, n, n2, n3);
            graphics2D.setComposite(composite);
        } else {
            this.drawHPbar(graphics2D, n, n2, n3);
        }
    }

    @Override
    protected Sprite getAnimationSprite() {
        Sprite sprite;
        OutfitStore outfitStore = OutfitStore.get();
        try {
            OutfitColor outfitColor = OutfitColor.get(((Player)this.entity).getRPObject());
            ZoneInfo zoneInfo = ZoneInfo.get();
            String string = ((Player)this.entity).getExtOutfit();
            int n = ((Player)this.entity).getOldOutfitCode();
            if (string == null) {
                int n2 = n % 100;
                int n3 = n / 100 % 100;
                int n4 = (int)((double)n / Math.pow(100.0, 2.0) % 100.0);
                int n5 = (int)((double)n / Math.pow(100.0, 3.0) % 100.0);
                int n6 = (int)((double)n / Math.pow(100.0, 4.0) % 100.0);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("body=" + n2);
                stringBuilder.append(",dress=" + n3);
                stringBuilder.append(",head=" + n4);
                stringBuilder.append(",hair=" + n5);
                stringBuilder.append(",detail=" + n6);
                sprite = outfitStore.getAdjustedOutfit(stringBuilder.toString(), outfitColor, zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
            } else {
                sprite = outfitStore.getAdjustedOutfit(string, outfitColor, zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
            }
            if (((Player)this.entity).hasStatus(StatusID.ZOMBIE)) {
                sprite = SpriteStore.get().modifySprite(sprite, ZOMBIE_COLOR, Blend.TrueColor, null);
            }
        }
        catch (RuntimeException runtimeException) {
            logger.warn((Object)"Cannot build outfit. Setting failsafe outfit.", (Throwable)runtimeException);
            sprite = outfitStore.getFailsafeOutfit();
        }
        return this.addShadow(sprite);
    }

    @Override
    protected AlphaComposite getComposite() {
        if (User.isIgnoring(((Player)this.entity).getName()) && !((Player)this.entity).isGhostMode()) {
            return AlphaComposite.DstOut;
        }
        return super.getComposite();
    }

    @Override
    protected boolean isVisibleGhost() {
        return User.isAdmin();
    }

    @Override
    protected void buildActions(List<String> list) {
        if (!((Player)this.entity).isGhostMode()) {
            super.buildActions(list);
            boolean bl = User.hasBuddy(((Player)this.entity).getName());
            if (!bl) {
                list.add(ActionType.ADD_BUDDY.getRepresentation());
            }
            if (User.isIgnoring(((Player)this.entity).getName())) {
                list.add(ActionType.UNIGNORE.getRepresentation());
            } else if (!bl) {
                list.add(ActionType.IGNORE.getRepresentation());
            }
            if (StendhalClient.serverVersionAtLeast("0.01")) {
                list.add(ActionType.TRADE.getRepresentation());
                list.add(ActionType.INVITE.getRepresentation());
                if (System.getProperty("stendhal.pvpchallenge") != null) {
                    list.add(ActionType.CHALLENGE.getRepresentation());
                    list.add(ActionType.ACCEPT_CHALLENGE.getRepresentation());
                }
            }
        }
    }

    @Override
    protected void draw(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        boolean bl = User.isIgnoring(((Player)this.entity).getName());
        if (bl != this.ignored) {
            this.visibilityChanged = true;
            this.ignored = bl;
            this.markChanged();
        }
        super.draw(graphics2D, n, n2, n3, n4);
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        if (actionType == null) {
            super.onAction(null);
            return;
        }
        switch (actionType) {
            case ADD_BUDDY: 
            case CHALLENGE: 
            case ACCEPT_CHALLENGE: 
            case IGNORE: 
            case INVITE: 
            case UNIGNORE: 
            case TRADE: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    @Override
    public boolean isInteractive() {
        if (((Player)this.entity).isGhostMode() && !this.isVisibleGhost()) {
            return false;
        }
        return super.isInteractive();
    }

    @Override
    public StendhalCursor getCursor() {
        if (this.isInteractive()) {
            return StendhalCursor.LOOK;
        }
        return null;
    }

    static {
        SpriteStore spriteStore = SpriteStore.get();
        Sprite sprite = spriteStore.getSprite("data/sprites/ideas/away.png");
        Sprite sprite2 = spriteStore.getSprite("data/sprites/ideas/grumpy.png");
        Sprite sprite3 = spriteStore.getSprite("data/sprites/ideas/pk.png");
        skullSprite = spriteStore.getAnimatedSprite(sprite3, 16, 200);
        awaySprite = spriteStore.getAnimatedSprite(sprite, 1000);
        grumpySprite = spriteStore.getAnimatedSprite(sprite2, 500);
    }
}

