/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Sign;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.SpriteStore;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

class Sign2DView<T extends Sign>
extends Entity2DView<T> {
    private static Logger logger = Logger.getLogger(Sign2DView.class);

    Sign2DView() {
    }

    @Override
    protected void buildActions(List<String> list) {
        ActionType actionType = this.getActionType();
        list.add(actionType.getRepresentation());
        super.buildActions(list);
        list.remove(ActionType.LOOK.getRepresentation());
    }

    @Override
    protected void buildRepresentation(T t) {
        String string = this.getClassResourcePath();
        if (string == null) {
            string = "default";
        }
        ZoneInfo zoneInfo = ZoneInfo.get();
        this.setSprite(SpriteStore.get().getModifiedSprite(this.translate(string), zoneInfo.getZoneColor(), zoneInfo.getColorMethod()));
    }

    @Override
    public int getZIndex() {
        return 5000;
    }

    @Override
    protected String translate(String string) {
        return "data/sprites/signs/" + string + ".png";
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        }
    }

    @Override
    public void onAction() {
        this.onAction(this.getActionType());
    }

    @Override
    public void onAction(ActionType actionType) {
        if (this.isReleased()) {
            return;
        }
        switch (actionType) {
            case LOOK_CLOSELY: 
            case READ: {
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    private ActionType getActionType() {
        Sign sign = (Sign)this.entity;
        if (sign == null) {
            return ActionType.LOOK;
        }
        String string = sign.getAction();
        if (string == null) {
            return ActionType.LOOK;
        }
        try {
            return ActionType.valueOf(string.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)("Unknown action for sign: " + string));
            return ActionType.LOOK;
        }
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.LOOK;
    }
}

