/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

abstract class StateEntity2DView<T extends IEntity>
extends Entity2DView<T> {
    private static final Logger logger = Logger.getLogger(StateEntity2DView.class);
    protected Map<Object, Sprite> sprites = new HashMap<Object, Sprite>();

    StateEntity2DView() {
    }

    private void buildAnimations(T t) {
        this.buildSprites(t, this.sprites);
    }

    protected abstract void buildSprites(T var1, Map<Object, Sprite> var2);

    protected Sprite getSprite(Object object) {
        return this.sprites.get(object);
    }

    protected abstract Object getState(T var1);

    private Sprite getStateSprite(T t) {
        Object object = this.getState(t);
        Sprite sprite = this.getSprite(object);
        if (sprite == null) {
            logger.debug((Object)("No sprite found for: " + object));
            return SpriteStore.get().getFailsafe();
        }
        return sprite;
    }

    @Override
    protected void buildRepresentation(T t) {
        this.buildAnimations(t);
        this.setSprite(this.getStateSprite(t));
    }

    protected void proceedChangedState(T t) {
        this.setSprite(this.getStateSprite(t));
    }
}

