/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity.helpers;

import games.stendhal.client.MemoryCache;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.common.Direction;
import games.stendhal.common.constants.Nature;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;

public final class AttackPainter {
    private static final Logger logger = Logger.getLogger(AttackPainter.class);
    private static final int NUM_ATTACK_FRAMES = 3;
    private static final int TILE_SIZE = 32;
    private static final int HALF_TILE = 16;
    private static final int ICON_OFFSET = 8;
    private static final MemoryCache<NatureRef, Map<Direction, Sprite[]>> SWEEP_CACHE = new MemoryCache();
    private static final MemoryCache<WeaponRef, Map<Direction, Sprite[]>> WEAPON_CACHE = new MemoryCache();
    private static final Map<Nature, Color> ARROW_COLOR;
    private static final Stroke ARROW_STROKE;
    private final Map<Direction, Sprite[]> map;
    private final Map<Direction, Sprite[]> weaponMap;
    private final Map<Direction, Sprite[]> rangedWeaponMap;
    private Sprite[] sprites;
    private Sprite[] weaponSprites;
    private Sprite[] rangedSprites;
    private int frame;
    private final Nature nature;
    private final String weapon;

    private AttackPainter(Nature nature, String string, Map<Direction, Sprite[]> map, Map<Direction, Sprite[]> map2, Map<Direction, Sprite[]> map3) {
        this.nature = nature;
        this.map = map;
        this.weaponMap = map2;
        this.rangedWeaponMap = map3;
        this.weapon = string;
    }

    public static AttackPainter get(Nature nature, final String string, int n) {
        Object object;
        Map<Direction, Sprite[]> map = null;
        Map<Direction, Sprite[]> map2 = null;
        if (string != null) {
            object = string + "_" + nature.toString().toLowerCase();
            WeaponRef weaponRef = new WeaponRef((String)object, n);
            if (!"ranged".equals(string)) {
                map = AttackPainter.getSpriteMap(weaponRef, n, WEAPON_CACHE, new SpriteMaker((String)object, string){
                    final /* synthetic */ String val$weapon_nature;
                    final /* synthetic */ String val$weapon;
                    {
                        this.val$weapon_nature = string;
                        this.val$weapon = string2;
                    }

                    @Override
                    public Sprite getSprite() {
                        Sprite sprite = AttackPainter.createWeaponImage(this.val$weapon_nature);
                        if (sprite == null) {
                            sprite = AttackPainter.createWeaponImage(this.val$weapon);
                        }
                        return sprite;
                    }
                });
            } else {
                map2 = AttackPainter.getSpriteMap(weaponRef, n, WEAPON_CACHE, new SpriteMaker(){

                    @Override
                    public Sprite getSprite() {
                        SpriteStore spriteStore = SpriteStore.get();
                        Sprite sprite = spriteStore.getCombatSprite(string + ".png");
                        if (sprite == spriteStore.getFailsafe()) {
                            return null;
                        }
                        return sprite;
                    }
                });
            }
        }
        object = AttackPainter.getSpriteMap(nature, n);
        return new AttackPainter(nature, string, (Map<Direction, Sprite[]>)object, map, map2);
    }

    private static Sprite createWeaponImage(String string) {
        SpriteStore spriteStore = SpriteStore.get();
        if (!spriteStore.existsSprite("data/sprites/combat/" + string + ".png")) {
            logger.debug((Object)("Weapon sprite \"" + string + ".png\" not found"));
            return null;
        }
        Sprite sprite = spriteStore.getCombatSprite(string + ".png");
        if (sprite == spriteStore.getFailsafe()) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(288, 512, TransparencyMode.TRANSPARENCY);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n = 96;
        int n2 = 128;
        graphics2D.clipRect(n, 0, n, n2);
        sprite.draw(graphics2D, 84, 40);
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.rotate(-0.7853981633974483);
        sprite.draw(graphics2D, -87, 46);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.clipRect(2 * n, 0, n, n2);
        graphics2D.rotate(0.7853981633974483);
        sprite.draw(graphics2D, 179, -160);
        graphics2D.setClip(null);
        sprite.draw(graphics2D, 105, 52);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.clipRect(n, n2, n, n2);
        graphics2D.rotate(1.5707963267948966);
        sprite.draw(graphics2D, 147, -192);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.clipRect(2 * n, n2, n, n2);
        graphics2D.rotate(2.356194490192345);
        sprite.draw(graphics2D, -70, -373);
        graphics2D.setClip(null);
        sprite.draw(graphics2D, 144, -308);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.clipRect(n, 2 * n2, n, n2);
        graphics2D.rotate(Math.PI);
        sprite.draw(graphics2D, -187, -383);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.clipRect(2 * n, 2 * n2, n, n2);
        graphics2D.rotate(-2.356194490192345);
        sprite.draw(graphics2D, -457, -120);
        graphics2D.setClip(null);
        sprite.draw(graphics2D, -427, -343);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.clipRect(n, 3 * n2, n, n2);
        graphics2D.rotate(-1.5707963267948966);
        sprite.draw(graphics2D, -507, 96);
        graphics2D.dispose();
        graphics2D = bufferedImage.createGraphics();
        graphics2D.clipRect(2 * n, 3 * n2, n, n2);
        graphics2D.rotate(-0.7853981633974483);
        sprite.draw(graphics2D, -204, 439);
        graphics2D.dispose();
        return new ImageSprite(bufferedImage);
    }

    private static Map<Direction, Sprite[]> getSpriteMap(final Nature nature, int n) {
        NatureRef natureRef = new NatureRef(nature, n);
        return AttackPainter.getSpriteMap(natureRef, n, SWEEP_CACHE, new SpriteMaker(){

            @Override
            public Sprite getSprite() {
                SpriteStore spriteStore = SpriteStore.get();
                return spriteStore.getCombatSprite("blade_strike_" + nature.toString().toLowerCase(Locale.US) + ".png");
            }
        });
    }

    private static <T> Map<Direction, Sprite[]> getSpriteMap(T t, int n, MemoryCache<T, Map<Direction, Sprite[]>> memoryCache, SpriteMaker spriteMaker) {
        Map<Direction, Sprite[]> map = memoryCache.get(t);
        if (map == null) {
            if (n == 1) {
                Sprite sprite = spriteMaker.getSprite();
                if (sprite == null) {
                    return null;
                }
                SpriteStore spriteStore = SpriteStore.get();
                map = AttackPainter.splitTiles(spriteStore, sprite);
                memoryCache.put(t, map);
            } else {
                Map<Direction, Sprite[]> map2 = AttackPainter.getSpriteMap(t, 1, memoryCache, spriteMaker);
                if (map2 != null) {
                    map = AttackPainter.scale(map2, n);
                    memoryCache.put(t, map);
                }
            }
        }
        return map;
    }

    private static Map<Direction, Sprite[]> scale(Map<Direction, Sprite[]> map, int n) {
        EnumMap<Direction, Sprite[]> enumMap = new EnumMap<Direction, Sprite[]>(Direction.class);
        for (Direction direction : Direction.values()) {
            Sprite[] spriteArray = map.get((Object)direction);
            if (spriteArray == null) continue;
            Sprite[] spriteArray2 = new Sprite[spriteArray.length];
            for (int i = 0; i < 3; ++i) {
                Sprite sprite = spriteArray[i];
                GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                int n2 = sprite.getWidth() + (n - 1) * 32;
                double d = (double)n2 / (double)sprite.getWidth();
                BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n2, (int)((double)sprite.getHeight() * d), TransparencyMode.TRANSPARENCY);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.scale(d, d);
                sprite.draw(graphics2D, 0, 0);
                graphics2D.dispose();
                spriteArray2[i] = new ImageSprite(bufferedImage);
            }
            enumMap.put(direction, spriteArray2);
        }
        return enumMap;
    }

    private static Map<Direction, Sprite[]> splitTiles(SpriteStore spriteStore, Sprite sprite) {
        int n = 96;
        int n2 = 128;
        EnumMap<Direction, Sprite[]> enumMap = new EnumMap<Direction, Sprite[]>(Direction.class);
        int n3 = 0;
        enumMap.put(Direction.UP, spriteStore.getTiles(sprite, 0, n3, 3, n, n2));
        enumMap.put(Direction.RIGHT, spriteStore.getTiles(sprite, 0, n3 += n2, 3, n, n2));
        enumMap.put(Direction.DOWN, spriteStore.getTiles(sprite, 0, n3 += n2, 3, n, n2));
        enumMap.put(Direction.LEFT, spriteStore.getTiles(sprite, 0, n3 += n2, 3, n, n2));
        return enumMap;
    }

    public void draw(Graphics2D graphics2D, Direction direction, int n, int n2, int n3, int n4) {
        this.drawAttackSprite(graphics2D, this.sprites, direction, n, n2, n3, n4);
        this.drawAttackSprite(graphics2D, this.weaponSprites, direction, n, n2, n3, n4);
        ++this.frame;
    }

    private void drawAttackSprite(Graphics2D graphics2D, Sprite[] spriteArray, Direction direction, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (spriteArray == null) {
            return;
        }
        Sprite sprite = spriteArray[this.frame];
        int n7 = sprite.getWidth();
        int n8 = sprite.getHeight();
        switch (direction) {
            case UP: {
                n6 = n + (n3 - n7) / 2 + 16;
                n5 = n2 - 16 - 32;
                break;
            }
            case DOWN: {
                n6 = n + (n3 - n7) / 2;
                n5 = n2 + n4 - n8 + 16;
                break;
            }
            case LEFT: {
                n6 = n - 16;
                n5 = n2 + (n4 - n8) / 2 - 16;
                break;
            }
            case RIGHT: {
                n6 = n + n3 - n7 + 16;
                n5 = n2 + (n4 - n8) / 2 - 8;
                break;
            }
            default: {
                n6 = n + (n3 - n7) / 2;
                n5 = n2 + (n4 - n8) / 2;
            }
        }
        sprite.draw(graphics2D, n6, n5);
    }

    public void drawDistanceAttack(Graphics2D graphics2D, RPEntity rPEntity, IEntity iEntity, int n, int n2, int n3, int n4) {
        Nature nature = rPEntity.getShownDamageType();
        int n5 = n + n3 / 2;
        int n6 = n2 + n4 / 2;
        int n7 = (int)(32.0 * (iEntity.getX() + iEntity.getWidth() / 2.0));
        int n8 = (int)(32.0 * iEntity.getY());
        int n9 = (n8 - n6) / 3;
        int n10 = (n7 - n5) / 3;
        n8 = (n6 += this.frame * n9) + n9;
        n7 = (n5 += this.frame * n10) + n10;
        graphics2D.setColor(ARROW_COLOR.get((Object)nature));
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(ARROW_STROKE);
        graphics2D.drawLine(n5, n6, n7, n8);
        graphics2D.setStroke(stroke);
        this.drawAttackSprite(graphics2D, this.rangedSprites, rPEntity.getDirection(), n, n2, n3, n4);
        ++this.frame;
    }

    public boolean hasNatureAndWeapon(Nature nature, String string) {
        return this.nature == nature && Objects.equals(this.weapon, string);
    }

    public boolean isDoneAttacking() {
        if (this.frame < 3) {
            return false;
        }
        this.frame = 0;
        return true;
    }

    public void prepare(Direction direction) {
        this.sprites = this.map.get((Object)direction);
        this.weaponSprites = this.weaponMap != null ? this.weaponMap.get((Object)direction) : null;
        this.rangedSprites = this.rangedWeaponMap != null ? this.rangedWeaponMap.get((Object)direction) : null;
        this.frame = 0;
    }

    static {
        ARROW_STROKE = new BasicStroke(2.0f);
        ARROW_COLOR = new EnumMap<Nature, Color>(Nature.class);
        ARROW_COLOR.put(Nature.CUT, Color.LIGHT_GRAY);
        ARROW_COLOR.put(Nature.DARK, Color.DARK_GRAY);
        ARROW_COLOR.put(Nature.LIGHT, new Color(255, 240, 140));
        ARROW_COLOR.put(Nature.FIRE, new Color(255, 100, 0));
        ARROW_COLOR.put(Nature.ICE, new Color(140, 140, 255));
    }

    private static final class WeaponRef {
        private final String weapon;
        private final int size;

        WeaponRef(String string, int n) {
            this.weapon = string;
            this.size = n;
        }

        public boolean equals(Object object) {
            if (object instanceof WeaponRef) {
                WeaponRef weaponRef = (WeaponRef)object;
                return this.size == weaponRef.size && Objects.equals(this.weapon, weaponRef.weapon);
            }
            return false;
        }

        public int hashCode() {
            return this.weapon.hashCode() * 37 + this.size;
        }
    }

    private static final class NatureRef {
        private final Nature nature;
        private final int size;

        private NatureRef(Nature nature, int n) {
            this.nature = nature;
            this.size = n;
        }

        public boolean equals(Object object) {
            if (object instanceof NatureRef) {
                NatureRef natureRef = (NatureRef)object;
                return this.size == natureRef.size && this.nature == natureRef.nature;
            }
            return false;
        }

        public int hashCode() {
            return this.nature.hashCode() * 37 + this.size;
        }
    }

    private static interface SpriteMaker {
        public Sprite getSprite();
    }
}

