/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.login;

import games.stendhal.client.StendhalClient;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Player;
import games.stendhal.client.gui.TransparencyMode;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.j2d.entity.EntityViewFactory;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.stendhal;
import games.stendhal.common.constants.Testing;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import marauroa.client.BannedAddressException;
import marauroa.client.TimeoutException;
import marauroa.common.game.CharacterResult;
import marauroa.common.game.RPObject;
import marauroa.common.net.InvalidVersionException;
import org.apache.log4j.Logger;

public final class CharacterDialog
extends JDialog
implements Runnable {
    private static final long serialVersionUID = -8827654641088132946L;
    private static Logger logger = Logger.getLogger(CharacterDialog.class);
    private static final int DIALOG_WIDTH = 640;
    private static final int DIALOG_HEIGHT = 480;
    private static final int MAX_COLUMNS = 4;
    private static final int IMAGE_WIDTH = 48;
    private static final int IMAGE_HEIGHT = 64;
    private static final int MAX_CHARACTERS = 8;
    private final JComponent characterPanel;

    public CharacterDialog(Map<String, RPObject> map, JFrame jFrame) {
        super(jFrame);
        this.setTitle("Wybierz posta\u0107");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CharacterDialog.this.onClose();
            }
        });
        int n = 5;
        this.setLayout(new SBoxLayout(false, n));
        Container container = this.getContentPane();
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        }
        this.characterPanel = new JPanel();
        this.characterPanel.setBorder(null);
        int n2 = Math.min(4, map.keySet().size());
        GridLayout gridLayout = new GridLayout(0, n2);
        this.characterPanel.setLayout(gridLayout);
        JScrollPane jScrollPane = new JScrollPane(this.characterPanel);
        this.add((Component)jScrollPane, (Object)SLayout.EXPAND_X);
        this.addCharacters(map);
        JComponent jComponent = SBoxLayout.createContainer(true, 5);
        this.add((Component)jComponent, (Object)SLayout.EXPAND_X);
        SBoxLayout.addSpring(jComponent);
        JButton jButton = new JButton("Nowa Posta\u0107");
        jButton.setMnemonic(78);
        jButton.addActionListener(new CreateCharacterAction(this));
        if (map.keySet().size() >= 8) {
            jButton.setEnabled(false);
        }
        jComponent.add(jButton);
        JButton jButton2 = new JButton("Anuluj");
        jButton2.setMnemonic(67);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CharacterDialog.this.onClose();
            }
        });
        jComponent.add(jButton2);
        this.setSize(Math.min(this.getWidth(), 640), Math.min(this.getHeight(), 480));
        this.pack();
        if (jFrame != null) {
            jFrame.setEnabled(false);
            this.setLocationRelativeTo(jFrame);
        }
        Thread thread = new Thread((Runnable)this, "KeepAlive on character dialog");
        thread.setDaemon(true);
        thread.start();
        WindowUtils.closeOnEscape(this);
        this.setResizable(false);
        this.setVisible(true);
    }

    private void addCharacters(Map<String, RPObject> map) {
        for (Map.Entry<String, RPObject> entry : map.entrySet()) {
            JButton jButton = this.createCharacterButton(entry.getKey(), entry.getValue());
            this.characterPanel.add(jButton);
        }
    }

    private JButton createCharacterButton(final String string, RPObject rPObject) {
        Object object;
        Object object2;
        Player player = new Player(){

            @Override
            protected void onPosition(double d, double d2) {
            }

            @Override
            protected void addSounds(String string, String string2, String ... stringArray) {
            }
        };
        rPObject.put("x", 0);
        rPObject.put("y", 0);
        rPObject.remove("ghostmode");
        rPObject.remove("last_player_kill_time");
        player.initialize(rPObject);
        EntityView<IEntity> entityView = EntityViewFactory.create(player);
        ImageIcon imageIcon = null;
        if (entityView != null) {
            object2 = this.createCharacterImage(entityView);
            imageIcon = new ImageIcon((Image)object2);
        }
        object2 = new StringBuilder("<html>");
        ((StringBuilder)object2).append(string);
        if (rPObject.has("name")) {
            ((StringBuilder)object2).append("<br>Poziom: ");
            object = "0";
            if (rPObject.has("level")) {
                object = rPObject.get("level");
            }
            ((StringBuilder)object2).append((String)object);
            ((StringBuilder)object2).append("<br>Skille: ");
            String string2 = "0";
            if (rPObject.has("atk")) {
                string2 = rPObject.get("atk");
            }
            ((StringBuilder)object2).append(string2);
            ((StringBuilder)object2).append("/");
            String string3 = "0";
            if (rPObject.has("def")) {
                string3 = rPObject.get("def");
            }
            ((StringBuilder)object2).append(string3);
            if (Testing.COMBAT) {
                ((StringBuilder)object2).append("/");
                String string4 = "0";
                if (rPObject.has("ratk")) {
                    string4 = rPObject.get("ratk");
                }
                ((StringBuilder)object2).append(string4);
            }
        }
        ((StringBuilder)object2).append("</html>");
        object = new JButton(((StringBuilder)object2).toString(), imageIcon);
        ((AbstractButton)object).setMargin(new Insets(1, 1, 1, 1));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CharacterDialog.this.chooseCharacter(string);
            }
        });
        return object;
    }

    private Image createCharacterImage(EntityView<?> entityView) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(48, 64, TransparencyMode.TRANSPARENCY);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        graphics2D.translate(0, 28);
        entityView.draw(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void onClose() {
        if (this.getOwner() == null) {
            System.exit(0);
        }
        this.getOwner().setEnabled(true);
        this.setVisible(false);
        this.dispose();
    }

    private void chooseCharacter(String string) {
        try {
            StendhalClient.get().chooseCharacter(string);
            this.setVisible(false);
            stendhal.setDoLogin();
            this.dispose();
        }
        catch (TimeoutException timeoutException) {
            logger.error((Object)timeoutException, (Throwable)timeoutException);
            this.handleError("Up\u0142yn\u0105\u0142 limit czasu na po\u0142\u0105czenie. Zaloguj si\u0119 ponownie.", "Wybierz Posta\u0107");
        }
        catch (InvalidVersionException invalidVersionException) {
            logger.error((Object)invalidVersionException, (Throwable)invalidVersionException);
            this.handleError("Twoja wersja gry jest niekompatybilna z wersj\u0105 serwera.", "Wybierz Posta\u0107");
        }
        catch (BannedAddressException bannedAddressException) {
            logger.error((Object)bannedAddressException, (Throwable)bannedAddressException);
            this.handleError("Zaloguj si\u0119 ponownie.", "Wybierz Posta\u0107");
        }
    }

    private void handleError(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 0);
        if (this.getOwner() != null) {
            this.setVisible(false);
            this.getOwner().setEnabled(true);
            this.dispose();
        } else {
            System.exit(1);
        }
    }

    @Override
    public void run() {
        while (this.isVisible()) {
            StendhalClient.get().sendKeepAlive();
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    static class CreateCharacterAction
    implements ActionListener {
        private CharacterDialog parent;

        private CreateCharacterAction(CharacterDialog characterDialog) {
            this.parent = characterDialog;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(this.parent, "Wprowad\u017a imi\u0119 twojej postaci:", "Utw\u00f3rz Posta\u0107", 3);
            if (string == null) {
                return;
            }
            try {
                CharacterResult characterResult = StendhalClient.get().createCharacter(string, new RPObject());
                if (characterResult.getResult().failed()) {
                    JOptionPane.showMessageDialog(this.parent, characterResult.getResult().getText());
                } else {
                    this.parent.setVisible(false);
                }
            }
            catch (TimeoutException timeoutException) {
                logger.error((Object)timeoutException, (Throwable)timeoutException);
                this.parent.handleError("Up\u0142yn\u0105\u0142 limit czasu na po\u0142\u0105czenie. Zaloguj si\u0119 ponownie.", "Wybierz Posta\u0107");
            }
            catch (InvalidVersionException invalidVersionException) {
                logger.error((Object)invalidVersionException, (Throwable)invalidVersionException);
                this.parent.handleError("Twoja wersja gry jest niekompatybilna z wersj\u0105 serwera.", "Wybierz Posta\u0107");
            }
            catch (BannedAddressException bannedAddressException) {
                logger.error((Object)bannedAddressException, (Throwable)bannedAddressException);
                this.parent.handleError("Zaloguj si\u0119 ponownie.", "Wybierz Posta\u0107");
            }
        }
    }
}

