/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.map;

import games.stendhal.client.entity.User;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.sprite.DataLoader;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class InformationPanel
extends JComponent {
    private static final int MAX_SKULLS = 5;
    private static final int SKULLS_LEVEL_ADD = 3;
    private static final String[] dangerLevelStrings = new String[]{"Ten obszar wygl\u0105da na bezpieczny.", "Ten obszar jest stosunkowo bezpieczny.", "Ten obszar jest troch\u0119 niebezpieczny.", "Ten obszar jest niebezpieczny.", "Ten obszar jest bardzo niebezpieczny!", "Ten obszar jest wyj\u0105tkowo niebezpieczny. Uciekaj!"};
    private final JTextPane nameField;
    private final SimpleAttributeSet center = new SimpleAttributeSet();
    private final DangerIndicator dangerIndicator;
    private int dangerLevel;
    private final JComponent glassPane;

    InformationPanel() {
        this.setLayout(new OverlayLayout(this));
        JComponent jComponent = SBoxLayout.createContainer(false);
        this.glassPane = new JComponent(){};
        this.add(this.glassPane);
        this.add(jComponent);
        this.nameField = new JTextPane();
        StyleConstants.setAlignment(this.center, 1);
        this.nameField.setAlignmentX(0.5f);
        this.nameField.setOpaque(true);
        this.nameField.setBackground(this.getBackground());
        this.nameField.setForeground(Color.WHITE);
        this.nameField.setFocusable(false);
        this.nameField.setEditable(false);
        jComponent.add((Component)this.nameField, (Object)SLayout.EXPAND_X);
        this.dangerIndicator = new DangerIndicator(5);
        this.dangerIndicator.setAlignmentX(0.5f);
        jComponent.add(this.dangerIndicator);
        this.describeDanger(0);
    }

    private void describeDanger(int n) {
        this.glassPane.setToolTipText(dangerLevelStrings[n]);
    }

    void setZoneName(String string) {
        this.nameField.setText(string);
        StyledDocument styledDocument = this.nameField.getStyledDocument();
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), this.center, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InformationPanel.this.nameField.revalidate();
            }
        });
    }

    void setDangerLevel(double d) {
        int n = (int)Math.min(5L, Math.round(2.0 * d / (double)(User.getPlayerLevel() + 3)));
        if (this.dangerLevel != n) {
            this.dangerLevel = n;
            this.dangerIndicator.setRelativeDanger(n);
            this.describeDanger(n);
        }
    }

    private static class DangerIndicator
    extends JComponent {
        private static final ImageIcon skullIcon = new ImageIcon(DataLoader.getResource("data/gui/danger.png"));
        private final JComponent[] indicators;

        DangerIndicator(int n) {
            this.setLayout(new SBoxLayout(true));
            this.indicators = new JComponent[n];
            for (int i = 0; i < n; ++i) {
                JLabel jLabel = new JLabel(skullIcon);
                jLabel.setVisible(false);
                this.add(jLabel);
                this.indicators[i] = jLabel;
            }
        }

        void setRelativeDanger(int n) {
            for (int i = 0; i < this.indicators.length; ++i) {
                this.indicators[i].setVisible(i < n);
            }
        }
    }
}

