/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.map;

import games.stendhal.client.GameObjects;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.Zone;
import games.stendhal.client.entity.Chest;
import games.stendhal.client.entity.DomesticAnimal;
import games.stendhal.client.entity.EntityChangeListener;
import games.stendhal.client.entity.FlyOverArea;
import games.stendhal.client.entity.HousePortal;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Player;
import games.stendhal.client.entity.Portal;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.StatefulEntity;
import games.stendhal.client.entity.User;
import games.stendhal.client.entity.WalkBlocker;
import games.stendhal.client.entity.Wall;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.map.DomesticAnimalMapObject;
import games.stendhal.client.gui.map.FlyOverAreaMapObject;
import games.stendhal.client.gui.map.InformationPanel;
import games.stendhal.client.gui.map.MapObject;
import games.stendhal.client.gui.map.MapPanel;
import games.stendhal.client.gui.map.MovingMapObject;
import games.stendhal.client.gui.map.PlayerMapObject;
import games.stendhal.client.gui.map.PortalMapObject;
import games.stendhal.client.gui.map.RPEntityMapObject;
import games.stendhal.client.gui.map.SourceMapObject;
import games.stendhal.client.gui.map.WalkBlockerMapObject;
import games.stendhal.client.gui.map.WallMapObject;
import games.stendhal.client.listener.PositionChangeListener;
import games.stendhal.common.CollisionDetection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MapPanelController
implements GameObjects.GameObjectListener,
PositionChangeListener,
StendhalClient.ZoneChangeListener {
    private static final boolean supermanMode = System.getProperty("stendhal.superman") != null;
    private final JComponent container;
    private final MapPanel panel;
    private final InformationPanel infoPanel;
    final Map<IEntity, MapObject> mapObjects = new ConcurrentHashMap<IEntity, MapObject>();
    private double x;
    private double y;
    private volatile boolean needsRefresh;

    public MapPanelController(StendhalClient stendhalClient) {
        this.container = new MapContainer();
        this.container.setLayout(new SBoxLayout(false));
        this.panel = new MapPanel(this, stendhalClient);
        this.container.add(this.panel);
        this.infoPanel = new InformationPanel();
        this.infoPanel.setBackground(Color.BLACK);
        this.container.add((Component)this.infoPanel, (Object)SLayout.EXPAND_X);
        stendhalClient.getGameObjects().addGameObjectListener(this);
    }

    void setNeedsRefresh(boolean bl) {
        this.needsRefresh = bl;
    }

    public JComponent getComponent() {
        return this.container;
    }

    @Override
    public void addEntity(IEntity iEntity) {
        MapObject mapObject = null;
        if (iEntity instanceof Player) {
            mapObject = new PlayerMapObject(iEntity);
        } else if (iEntity instanceof RPEntity && !((RPEntity)iEntity).isImmortal()) {
            mapObject = new RPEntityMapObject(iEntity);
        } else if (iEntity instanceof Portal) {
            Portal portal = (Portal)iEntity;
            if (!portal.isHidden()) {
                this.mapObjects.put(iEntity, new PortalMapObject(iEntity));
            }
        } else if (iEntity instanceof HousePortal) {
            mapObject = new PortalMapObject(iEntity);
        } else if (iEntity instanceof WalkBlocker) {
            mapObject = new WalkBlockerMapObject(iEntity);
        } else if (iEntity instanceof FlyOverArea) {
            mapObject = new FlyOverAreaMapObject(iEntity);
        } else if (iEntity instanceof Wall) {
            mapObject = new WallMapObject(iEntity);
        } else if (iEntity instanceof DomesticAnimal) {
            mapObject = new DomesticAnimalMapObject((DomesticAnimal)iEntity);
        } else if (iEntity instanceof Chest) {
            mapObject = new RPEntityMapObject(iEntity){
                {
                    this.drawColor = new Color(238, 130, 238);
                }
            };
        } else if (supermanMode && User.isAdmin()) {
            mapObject = new MovingMapObject(iEntity);
        } else if (iEntity instanceof StatefulEntity) {
            mapObject = new SourceMapObject(iEntity);
        }
        if (mapObject != null) {
            this.mapObjects.put(iEntity, mapObject);
            if (mapObject instanceof MovingMapObject) {
                iEntity.addChangeListener(new EntityChangeListener<IEntity>(){

                    @Override
                    public void entityChanged(IEntity iEntity, Object object) {
                        if (object == IEntity.PROP_POSITION || object == RPEntity.PROP_GHOSTMODE || object == RPEntity.PROP_GROUP_MEMBERSHIP) {
                            MapPanelController.this.needsRefresh = true;
                        }
                    }
                });
            }
            this.needsRefresh = true;
        }
    }

    @Override
    public void removeEntity(IEntity iEntity) {
        if (this.mapObjects.remove(iEntity) != null) {
            this.needsRefresh = true;
        }
    }

    public void refresh() {
        if (this.needsRefresh) {
            this.panel.repaint();
        }
    }

    private void update(CollisionDetection collisionDetection, CollisionDetection collisionDetection2, CollisionDetection collisionDetection3, final String string, final double d) {
        this.panel.update(collisionDetection, collisionDetection2, collisionDetection3);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapPanelController.this.infoPanel.setZoneName(string);
                MapPanelController.this.infoPanel.setDangerLevel(d);
            }
        });
    }

    @Override
    public void positionChanged(final double d, final double d2) {
        if (this.x != d || this.y != d2) {
            this.x = d;
            this.y = d2;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPanelController.this.panel.positionChanged(d, d2);
                    MapPanelController.this.setNeedsRefresh(true);
                }
            });
        }
    }

    @Override
    public void onZoneChange(Zone zone) {
    }

    @Override
    public void onZoneChangeCompleted(Zone zone) {
        this.update(zone.getCollision(), zone.getProtection(), zone.getSecret(), zone.getReadableName(), zone.getDangerLevel());
    }

    @Override
    public void onZoneUpdate(Zone zone) {
        this.update(zone.getCollision(), zone.getProtection(), zone.getSecret(), zone.getReadableName(), zone.getDangerLevel());
    }

    private static class MapContainer
    extends JComponent {
        private MapContainer() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

