/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.settings;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.actions.MoveContinuousAction;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.settings.SettingsComponentFactory;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.wt.core.SettingChangeListener;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.NotificationType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;

class GeneralSettings {
    private static final String GAMESCREEN_AUTORAISECORPSE = "gamescreen.autoinspectcorpses";
    private static final String DOUBLE_CLICK_PROPERTY = "ui.doubleclick";
    private static final String HEALING_MESSAGE_PROPERTY = "ui.healingmessage";
    private static final String POISON_MESSAGE_PROPERTY = "ui.poisonmessage";
    private static final String DIMENSIONS_PROPERTY = "ui.dimensions";
    private final JComponent page;

    GeneralSettings() {
        int n = 5;
        this.page = SBoxLayout.createContainer(false, n);
        this.page.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        JCheckBox jCheckBox = SettingsComponentFactory.createSettingsToggle(DOUBLE_CLICK_PROPERTY, false, "Tryb podw\u00f3jnego klikania", "Poruszanie i atak za pomoc\u0105 podw\u00f3jnego klikni\u0119cia. Je\u017celi nie zaznaczony to domy\u015blnym jest pojedy\u0144cze klikni\u0119cie.");
        this.page.add(jCheckBox);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Tryb podw\u00f3jnego klikania zosta\u0142o ");
            }
        });
        JCheckBox jCheckBox2 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_AUTORAISECORPSE, true, "Auto sprawdzanie zw\u0142ok", "Automatycznie otwiera okno zw\u0142ok potwora, z kt\u00f3rego mo\u017cesz wzi\u0105\u0107 sw\u00f3j \u0142up");
        this.page.add(jCheckBox2);
        jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Automatyczne sprawdzanie zw\u0142ok zosta\u0142o ");
            }
        });
        JCheckBox jCheckBox3 = SettingsComponentFactory.createSettingsToggle(HEALING_MESSAGE_PROPERTY, false, "Poka\u017c wiadomo\u015bci o leczeniu", "Pokazuje wiadomo\u015bci o leczeniu w oknie rozmowy");
        this.page.add(jCheckBox3);
        jCheckBox3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Wiadomo\u015bci o leczeniu zosta\u0142y ");
            }
        });
        JCheckBox jCheckBox4 = SettingsComponentFactory.createSettingsToggle(POISON_MESSAGE_PROPERTY, false, "Poka\u017c wiadomo\u015bci o zatruciu", "Pokazuje wiadomo\u015bci o zatruciu w oknie rozmowy");
        this.page.add(jCheckBox4);
        jCheckBox4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Wiadomo\u015bci o zatruciu zosta\u0142y ");
            }
        });
        JCheckBox jCheckBox5 = SettingsComponentFactory.createSettingsToggle("move.doubletapautowalk", false, "Automatyczne chodzenie (zbugowane)", "W\u0142\u0105cza automatyczne chodzenie, gdy klawisz kierunkowy zosta\u0142 podw\u00f3jnie klikni\u0119ty");
        this.page.add(jCheckBox5);
        jCheckBox5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GeneralSettings.this.getState(itemEvent, "Automatyczne chodzenie zosta\u0142o ");
            }
        });
        final JCheckBox jCheckBox6 = SettingsComponentFactory.createSettingsToggle("move.continuous", false, "Ci\u0105g\u0142y ruch", "Zmieniaj mapy i przechod\u017a przez portale bez zatrzymywania si\u0119");
        jCheckBox6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new MoveContinuousAction().sendAction(jCheckBox6.isSelected());
            }
        });
        WtWindowManager.getInstance().registerSettingChangeListener("move.continuous", new SettingChangeListener(){

            @Override
            public void changed(String string) {
                jCheckBox6.setSelected(Boolean.parseBoolean(string));
            }
        });
        this.page.add(jCheckBox6);
        JCheckBox jCheckBox7 = SettingsComponentFactory.createSettingsToggle("ui.msg_blink", true, "Migaj przy wiadomo\u015bci na kanale prywatnym", "Karta kana\u0142u czatu miga w wiadomo\u015bci, gdy nie jest skoncentrowana");
        this.page.add(jCheckBox7);
        JCheckBox jCheckBox8 = SettingsComponentFactory.createSettingsToggle("ui.msg_sound", true, "Powiadomienie d\u017awi\u0119kowe o prywatnej wiadomo\u015bci", "Odtwarzaj d\u017awi\u0119k dla kana\u0142u wiadomo\u015bci osobistych, gdy nie jest skoncentrowany");
        this.page.add(jCheckBox8);
        JComponent jComponent = SBoxLayout.createContainer(false, n);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rozmiar Klienta");
        Style style = StyleUtil.getStyle();
        if (style != null) {
            jComponent.setBackground(style.getPlainColor());
            titledBorder.setTitleColor(style.getForeground());
        }
        jComponent.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(n, n, n, n)));
        JCheckBox jCheckBox9 = SettingsComponentFactory.createSettingsToggle(DIMENSIONS_PROPERTY, true, "Zapisz rozmiar", "Przywr\u00f3\u0107 szeroko\u015b\u0107, wysoko\u015b\u0107 i maksymalizuj klienta podczas przysz\u0142ych sesji");
        jComponent.add(jCheckBox9);
        JButton jButton = new JButton("Zresetuj");
        jButton.setToolTipText("Zresetuj szeroko\u015b\u0107 i wysoko\u015b\u0107 klienta do domy\u015blnych wymiar\u00f3w");
        jButton.setActionCommand("reset_dimensions");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralSettings.this.resetClientDimensions();
            }
        });
        jButton.setAlignmentX(1.0f);
        jComponent.add(jButton);
        this.page.add((Component)jComponent, (Object)SLayout.EXPAND_X);
    }

    JComponent getComponent() {
        return this.page;
    }

    private void getState(ItemEvent itemEvent, String string) {
        boolean bl = itemEvent.getStateChange() == 1;
        String string2 = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
        String string3 = string + string2 + ".";
        ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string3, NotificationType.CLIENT));
    }

    private void resetClientDimensions() {
        j2DClient j2DClient2 = j2DClient.get();
        j2DClient2.resetClientDimensions();
    }
}

