/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.settings;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.UiRenderingMethod;
import games.stendhal.client.gui.chatlog.EventLine;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.settings.SettingsComponentFactory;
import games.stendhal.client.gui.stats.StatsPanelController;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.client.gui.styled.StyledLookAndFeel;
import games.stendhal.client.gui.styled.styles.StyleFactory;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.MathHelper;
import games.stendhal.common.NotificationType;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

class VisualSettings {
    private static final String STYLE_PROPERTY = "ui.style";
    private static final String DEFAULT_STYLE = "Wood (domy\u015blny)";
    private static final String TRANSPARENCY_PROPERTY = "ui.transparency";
    private static final String DEFAULT_FONT = "AntykwaTorunska";
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final int FONT_MIN_SIZE = 8;
    private static final int FONT_MAX_SIZE = 20;
    private static final String FONT_PROPERTY = "ui.logfont";
    private static final String FONT_SIZE_PROPERTY = "ui.font_size";
    private static final String GAMESCREEN_CREATURESPEECH = "gamescreen.creaturespeech";
    private static final String GAMESCREEN_BLOOD = "gamescreen.blood";
    private static final String GAMESCREEN_NONUDE = "gamescreen.nonude";
    private static final String GAMESCREEN_CURSORCLASSIC = "gamescreen.cursorclassic";
    private static final String SCALE_SCREEN_PROPERTY = "ui.scale_screen";
    private static final String MAP_COLOR_PROPERTY = "ui.colormaps";
    private final JComponent page;

    VisualSettings() {
        int n = 5;
        this.page = SBoxLayout.createContainer(false, n);
        this.page.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        this.page.add((Component)this.createStyleTypeSelector(), (Object)SLayout.EXPAND_X);
        this.page.add((Component)this.createRenderingSelector(), (Object)SLayout.EXPAND_X);
        this.page.add((Component)this.createTransparencySelector(), (Object)SLayout.EXPAND_X);
        this.toggleComponents(this.page);
        JCheckBox jCheckBox = SettingsComponentFactory.createSettingsToggle(MAP_COLOR_PROPERTY, true, "Efekty \u015bwietlne", "Poka\u017c nocne \u015bwiat\u0142a i inne kolorowe efekty");
        this.page.add(jCheckBox);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
                String string2 = "Efekty \u015bwietlne s\u0105 teraz " + string + ". Mo\u017cesz zmieni\u0107 map\u0119 lub przelogowa\u0107 si\u0119, aby zmiana zadzia\u0142a\u0142a.";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox2 = SettingsComponentFactory.createSettingsToggle("ui.draw_weather", true, "Poka\u017c pogod\u0119", "Pokazuje efekty pogodowe.");
        this.page.add(jCheckBox2);
        jCheckBox2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
                String string2 = "Efekty pogodowe zosta\u0142y " + string + ".";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox3 = SettingsComponentFactory.createSettingsToggle("gamescreen.shadows", true, "Poka\u017c cienie", "Pokazuje cienie pod r\u00f3\u017cnymi obiektami.");
        this.page.add(jCheckBox3);
        jCheckBox3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
                String string2 = "Cienie zosta\u0142y " + string + ". Niekt\u00f3re zmiany zaczn\u0105 dzia\u0142a\u0107 dopiero po zmianie mapy lub przelogowaniu si\u0119.";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox4 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_BLOOD, true, "Poka\u017c krew i zw\u0142oki", "Pokazuje plamy krwi podczas uderzenia w walce i zw\u0142oki.");
        this.page.add(jCheckBox4);
        jCheckBox4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
                String string2 = "Krew i zw\u0142oki zosta\u0142y " + string + ". Niekt\u00f3re zmiany zaczn\u0105 dzia\u0142a\u0107 dopiero po ponownym uruchomieniu klienta.";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox5 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_NONUDE, true, "Poka\u017c bielizn\u0119", "\"Nagie\" postacie zostan\u0105 pokryte bielizn\u0105.");
        this.page.add(jCheckBox5);
        jCheckBox5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czona" : "wy\u0142\u0105czona";
                String string2 = "Bielizna zosta\u0142a " + string + ". Niekt\u00f3re zmiany zaczn\u0105 dzia\u0142a\u0107 dopiero po zmianie mapy lub przelogowaniu si\u0119.";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox6 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_CURSORCLASSIC, false, "Poka\u017c klasyczny kursor", "Klasyczny wygl\u0105d kursora.");
        this.page.add(jCheckBox6);
        jCheckBox6.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czony" : "wy\u0142\u0105czony";
                String string2 = "Klasyczny kursor zosta\u0142 " + string + ". Zmiana wygl\u0105du kursora zacznie dzia\u0142a\u0107 dopiero po przelogowaniu si\u0119.";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox7 = SettingsComponentFactory.createSettingsToggle(GAMESCREEN_CREATURESPEECH, true, "Poka\u017c dymki potwor\u00f3w", "Pokazuje dymki z tekstem potwor\u00f3w w ekranie klienta");
        this.page.add(jCheckBox7);
        jCheckBox7.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
                String string2 = "Dymki potwor\u00f3w zosta\u0142y " + string + ".";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox8 = SettingsComponentFactory.createSettingsToggle(SCALE_SCREEN_PROPERTY, false, "Skaluj widok, aby pasowa\u0142 do okna", "<html>Je\u015bli znaznaczony to widok gry b\u0119dzie zeskalowany, aby pasowa\u0142 do dost\u0119pnego miejsca,<br>w przeciwnym wypadku b\u0119dzie domy\u015blny rozmiar grafiki.</html>");
        this.page.add(jCheckBox8);
        jCheckBox8.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
                String string2 = "Skalowanie widoku gry zosta\u0142o " + string + ".";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        JCheckBox jCheckBox9 = SettingsComponentFactory.createSettingsToggle("ui.hp_bar", true, "Poka\u017c pasek zdrowia", "Pokazuje pasek reprezentuj\u0105cy aktualne zdrowie.");
        jCheckBox9.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                StatsPanelController.get().toggleHPBar(itemEvent.getStateChange() == 1);
            }
        });
        this.page.add(jCheckBox9);
        JCheckBox jCheckBox10 = SettingsComponentFactory.createSettingsToggle("ui.font.overrideaa", false, "Wymu\u015b wyg\u0142adzanie czcionki", "W\u0142\u0105cz t\u0119 opcj\u0119, je\u015bli klient nie rozpoznaje konfiguracji antyaliasingu czcionek na pulpicie.");
        jCheckBox10.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", "Zmiany zaczn\u0105 dzia\u0142a\u0107 po ponownym uruchomieniu klienta.", NotificationType.CLIENT));
            }
        });
        this.page.add(jCheckBox10);
        JCheckBox jCheckBox11 = SettingsComponentFactory.createSettingsToggle("ui.chat_bubbles", true, "Ruchome dymki chatu", "Dymki chatu pod\u0105\u017caj\u0105 za graczem i innymi obiektami.");
        jCheckBox11.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                String string = bl ? "w\u0142\u0105czone" : "wy\u0142\u0105czone";
                String string2 = "Ruchome dymki chatu zosta\u0142y " + string + ".";
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", string2, NotificationType.CLIENT));
            }
        });
        this.page.add(jCheckBox11);
        this.page.add(Box.createHorizontalStrut(5));
        this.page.add(this.createFontSizeSelector());
        this.page.add((Component)this.createFontSelector(), (Object)SLayout.EXPAND_X);
    }

    JComponent getComponent() {
        return this.page;
    }

    private JComponent createStyleSelector() {
        String string2;
        final JComboBox<String> jComboBox = new JComboBox<String>();
        for (String string2 : StyleFactory.getAvailableStyles()) {
            jComboBox.addItem(string2);
        }
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        string2 = wtWindowManager.getProperty(STYLE_PROPERTY, DEFAULT_STYLE);
        jComboBox.setSelectedItem(string2);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                wtWindowManager.setProperty(VisualSettings.STYLE_PROPERTY, object.toString());
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", "Nowy styl b\u0119dzie wykorzystywany przy kolejnym uruchomieniu klienta gry.", NotificationType.CLIENT));
            }
        });
        return jComboBox;
    }

    private JComponent createTransparencySelector() {
        JComponent jComponent = SBoxLayout.createContainer(true, 5);
        JLabel jLabel = new JLabel("Tryb przezroczysto\u015bci:");
        jComponent.add(jLabel);
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        String[][] stringArray = new String[][]{{"Automatyczny (domy\u015blny)", "auto", "Odpowiedni tryb jest wybierany automatycznie w zale\u017cno\u015bci od szybko\u015bci systemu."}, {"Pe\u0142na przezroczysto\u015b\u0107", "translucent", "B\u0119dzie u\u017cywa\u0142 p\u00f3\u0142przezroczystych obraz\u00f3w o ile to mo\u017cliwe. Mo\u017ce to spowolni\u0107 system."}, {"Prosta przezroczysto\u015b\u0107", "bitmask", "U\u017cyje prostej przezroczysto\u015bci tam gdzie obraz jest w pe\u0142ni przezroczysty lub ca\u0142kowicie nieprzezroczysty. <P>U\u017cyj tego ustawienia na starszych komputerach je\u015bli gra nie odpowiada."}};
        final HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        for (String[] object2 : stringArray) {
            jComboBox.addItem(object2[0]);
            hashMap.put(object2[0], object2);
            hashMap2.put(object2[1], object2);
        }
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        String string = wtWindowManager.getProperty(TRANSPARENCY_PROPERTY, "auto");
        String[] stringArray2 = (String[])hashMap2.get(string);
        if (stringArray2 == null) {
            stringArray2 = (String[])hashMap2.get("auto");
        }
        jComboBox.setSelectedItem(stringArray2[0]);
        jComboBox.setRenderer(new TooltippedRenderer(stringArray));
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                String[] stringArray = (String[])hashMap.get(object);
                wtWindowManager.setProperty(VisualSettings.TRANSPARENCY_PROPERTY, stringArray[1]);
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", "Nowy tryb prze\u017aroczysto\u015bci b\u0119dzie dzia\u0142a\u0142 przy nast\u0119pnym uruchomieniu klienta gry.", NotificationType.CLIENT));
            }
        });
        jComponent.add(jComboBox);
        StringBuilder stringBuilder = new StringBuilder("<html>Tryb prze\u017aroczysto\u015bci u\u017cyty dla grafiki. Dost\u0119pne opcje:<dl>");
        for (String[] stringArray3 : stringArray) {
            stringBuilder.append("<dt><b>");
            stringBuilder.append(stringArray3[0]);
            stringBuilder.append("</b></dt>");
            stringBuilder.append("<dd>");
            stringBuilder.append(stringArray3[2]);
            stringBuilder.append("</dd>");
        }
        stringBuilder.append("</dl></html>");
        jComponent.setToolTipText(stringBuilder.toString());
        jComboBox.setToolTipText(stringBuilder.toString());
        return jComponent;
    }

    private void toggleComponents(Container container) {
    }

    private JComponent createStyleTypeSelector() {
        int n = 5;
        JComponent jComponent = SBoxLayout.createContainer(false, n);
        JComponent jComponent2 = SBoxLayout.createContainer(true, n);
        JLabel jLabel = new JLabel("Styl klienta:");
        jLabel.setName("defined");
        jComponent2.add(jLabel);
        JComponent jComponent3 = this.createStyleSelector();
        jComponent3.setName("defined");
        jComponent2.add(jComponent3);
        jComponent2.setToolTipText("<html>Styl u\u017cyty do narysowania kontrolek w kliencie gry.<p>Wp\u0142ywa to tylko na wygl\u0105d i nie zmienia zachowania gry.</html>");
        jComponent.add(jComponent2);
        return jComponent;
    }

    private JComponent createRenderingSelector() {
        Object object;
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent(jList, ((RenderingMethod)object).name, n, bl, bl2);
            }
        });
        final WtWindowManager wtWindowManager = WtWindowManager.getInstance();
        String string = wtWindowManager.getProperty("ui.rendering", "");
        for (UiRenderingMethod object22 : UiRenderingMethod.getAvailableMethods()) {
            object = new RenderingMethod();
            ((RenderingMethod)object).method = object22;
            switch (object22) {
                case DEFAULT: {
                    ((RenderingMethod)object).name = "Domy\u015blny (system)";
                    break;
                }
                case SOFTWARE: {
                    if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                        ((RenderingMethod)object).name = "Windows API/GDI Renderowanie Systemowe";
                        break;
                    }
                    ((RenderingMethod)object).name = "Renderowanie Systemowe";
                    break;
                }
                case DIRECT_DRAW: {
                    ((RenderingMethod)object).name = "DirectDraw Only";
                    break;
                }
                case DDRAW_HWSCALE: {
                    ((RenderingMethod)object).name = "Skalowanie Direct3D HW";
                    break;
                }
                case OPEN_GL: {
                    ((RenderingMethod)object).name = "Open GL";
                    break;
                }
                case XRENDER: {
                    ((RenderingMethod)object).name = "XRender";
                    break;
                }
                case METAL: {
                    ((RenderingMethod)object).name = "Metal Framework";
                }
            }
            jComboBox.addItem(object);
            if (!object22.getPropertyValue().equals(string)) continue;
            jComboBox.setSelectedItem(object);
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RenderingMethod renderingMethod = (RenderingMethod)jComboBox.getSelectedItem();
                wtWindowManager.setProperty("ui.rendering", renderingMethod.method.getPropertyValue());
                ClientSingletonRepository.getUserInterface().addEventLine(new EventLine("", "Nowe renderowanie zostanie u\u017cyte przy nast\u0119pnym uruchomieniu klienta gry.", NotificationType.CLIENT));
            }
        });
        int n = 5;
        JComponent jComponent = SBoxLayout.createContainer(false, n);
        object = SBoxLayout.createContainer(true, n);
        JLabel jLabel = new JLabel("Renderowanie UI:");
        jLabel.setName("");
        ((Container)object).add(jLabel);
        jComboBox.setName("");
        ((Container)object).add(jComboBox);
        ((JComponent)object).setToolTipText("<html>Metoda renderowania u\u017cywana do rysowania klienta gry.</html>");
        jComponent.add((Component)object);
        return jComponent;
    }

    private JComponent createFontSizeSelector() {
        JComponent jComponent = SBoxLayout.createContainer(true, 5);
        jComponent.add(new JLabel("Rozmiar czcionki:"));
        final JComboBox<Object> jComboBox = new JComboBox<Object>();
        int n = WtWindowManager.getInstance().getPropertyInt(FONT_SIZE_PROPERTY, 12);
        jComboBox.addItem("domy\u015blny (12)");
        for (int i = 8; i <= 20; i += 2) {
            Integer n2 = i;
            jComboBox.addItem(n2);
            if (i != n || i == 12) continue;
            jComboBox.setSelectedItem(n2);
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = jComboBox.getSelectedItem();
                if ("domy\u015blny (12)".equals(object)) {
                    object = "12";
                }
                WtWindowManager.getInstance().setProperty(VisualSettings.FONT_SIZE_PROPERTY, object.toString());
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                if (lookAndFeel instanceof StyledLookAndFeel) {
                    int n = MathHelper.parseIntDefault(object.toString(), 12);
                    ((StyledLookAndFeel)lookAndFeel).setDefaultFontSize(n);
                }
            }
        });
        jComponent.add(jComboBox);
        jComponent.setToolTipText("Domy\u015blny rozmiar czcionki");
        return jComponent;
    }

    private JComponent createFontSelector() {
        int n = 5;
        JComponent jComponent = SBoxLayout.createContainer(false, n);
        jComponent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(n, n, n, n)));
        Style style = StyleUtil.getStyle();
        if (style != null) {
            jComponent.setBackground(style.getPlainColor());
        }
        JCheckBox jCheckBox = new JCheckBox("Niestandardowa czcionka dekoracyjna");
        jCheckBox.setToolTipText("Ustawia niestandardow\u0105 czcionk\u0119 dla dziennika podr\u00f3\u017cy i osi\u0105gni\u0119\u0107");
        jComponent.add(jCheckBox);
        JComponent jComponent2 = SBoxLayout.createContainer(true, n);
        SBoxLayout.addSpring(jComponent2);
        jComponent.add((Component)jComponent2, (Object)SLayout.EXPAND_X);
        final JLabel jLabel = new JLabel("Czcionka:");
        jComponent2.add(jLabel);
        final JComboBox<String> jComboBox = new JComboBox<String>();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String string : graphicsEnvironment.getAvailableFontFamilyNames()) {
            jComboBox.addItem(string);
        }
        String string = WtWindowManager.getInstance().getProperty(FONT_PROPERTY, DEFAULT_FONT);
        jComboBox.setSelectedItem(string);
        jComponent2.add(jComboBox);
        int n2 = this.fontChanged() ? 1 : 0;
        jCheckBox.setSelected(n2 != 0);
        jComboBox.setEnabled(n2 != 0);
        jLabel.setEnabled(n2 != 0);
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                boolean bl2 = bl = itemEvent.getStateChange() == 1;
                if (bl) {
                    String string = jComboBox.getSelectedItem().toString();
                    WtWindowManager.getInstance().setProperty(VisualSettings.FONT_PROPERTY, string);
                } else {
                    WtWindowManager.getInstance().setProperty(VisualSettings.FONT_PROPERTY, VisualSettings.DEFAULT_FONT);
                }
                jComboBox.setEnabled(bl);
                jLabel.setEnabled(bl);
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jComboBox.getSelectedItem().toString();
                WtWindowManager.getInstance().setProperty(VisualSettings.FONT_PROPERTY, string);
            }
        });
        return jComponent;
    }

    private boolean fontChanged() {
        String string = WtWindowManager.getInstance().getProperty(FONT_PROPERTY, DEFAULT_FONT);
        return !string.equals(DEFAULT_FONT);
    }

    private static class RenderingMethod {
        UiRenderingMethod method;
        String name;

        private RenderingMethod() {
        }
    }

    private static class TooltippedRenderer
    extends DefaultListCellRenderer {
        private final String[][] data;

        TooltippedRenderer(String[][] stringArray) {
            this.data = stringArray;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            JComponent jComponent = (JComponent)super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (n > -1 && object != null) {
                jList.setToolTipText("<html>" + this.data[n][2] + "</html>");
            }
            return jComponent;
        }
    }
}

