/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.spellcasting;

import games.stendhal.client.StaticGameLayers;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.DragLayer;
import games.stendhal.client.gui.GroundContainer;
import games.stendhal.client.gui.j2d.RemovableSprite;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.spellcasting.GroundContainerMouseState;
import games.stendhal.client.gui.spellcasting.SpellCastingGroundContainerMouseState;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.gui.wt.EntityViewCommandList;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DefaultGroundContainerMouseState
extends GroundContainerMouseState {
    public DefaultGroundContainerMouseState(GroundContainer groundContainer) {
        super(groundContainer);
    }

    @Override
    protected boolean onMouseClick(Point point) {
        if (this.ignoreClick) {
            this.ignoreClick = false;
            return false;
        }
        if (Math.abs(point.getX() - (double)this.xOnMousePressed) > 10.0 || Math.abs(point.getY() - (double)this.yOnMousePressed) > 10.0) {
            return false;
        }
        RemovableSprite removableSprite = this.ground.getScreen().getTextAt(point.x, point.y);
        if (removableSprite != null) {
            this.ground.getScreen().removeText(removableSprite);
            return true;
        }
        Point2D point2D = this.ground.getScreen().convertScreenViewToWorld(point);
        EntityView<?> entityView = this.ground.getScreen().getEntityViewAt(point2D.getX(), point2D.getY());
        boolean bl = WtWindowManager.getInstance().getPropertyBoolean("ui.doubleclick", false);
        if (entityView != null && entityView.isInteractive()) {
            if (this.isCtrlDown()) {
                entityView.onAction();
                return true;
            }
            if (this.isShiftDown()) {
                entityView.onAction(ActionType.LOOK);
                return true;
            }
            if (!bl) {
                return entityView.onHarmlessAction();
            }
        } else if (this.windowWasActiveOnMousePressed && !this.isCtrlDown() && !bl) {
            this.ground.createAndSendMoveToAction(point2D, false);
        }
        return false;
    }

    @Override
    protected boolean onMouseDoubleClick(Point point) {
        Point2D point2D = this.ground.getScreen().convertScreenViewToWorld(point);
        EntityView<?> entityView = this.ground.getScreen().getEntityViewAt(point2D.getX(), point2D.getY());
        if (entityView != null && entityView.isInteractive()) {
            entityView.onAction();
            return true;
        }
        this.ground.createAndSendMoveToAction(point2D, true);
        return true;
    }

    @Override
    protected void onMouseRightClick(Point point) {
        String[] stringArray;
        this.ignoreClick = false;
        Point2D point2D = this.ground.getScreen().convertScreenViewToWorld(point);
        EntityView<?> entityView = this.ground.getScreen().getEntityViewAt(point2D.getX(), point2D.getY());
        if (entityView != null && (stringArray = entityView.getActions()).length > 0) {
            Object obj = entityView.getEntity();
            EntityViewCommandList entityViewCommandList = new EntityViewCommandList(obj.getType(), stringArray, entityView);
            entityViewCommandList.show(this.ground.getCanvas(), point.x - 10, point.y - 10);
            this.contextMenuFlag = true;
            entityViewCommandList.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DefaultGroundContainerMouseState.this.contextMenuFlag = false;
                        }
                    });
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    @Override
    protected void onDragStart(Point point) {
        this.ignoreClick = false;
        Point2D point2D = this.ground.getScreen().convertScreenViewToWorld(point);
        EntityView<?> entityView = this.ground.getScreen().getMovableEntityViewAt(point2D.getX(), point2D.getY());
        if (entityView != null) {
            DragLayer.get().startDrag((IEntity)entityView.getEntity());
        }
    }

    @Override
    public void switchState() {
        this.ground.setNewMouseHandlerState(new SpellCastingGroundContainerMouseState(this.ground));
    }

    @Override
    public StendhalCursor getCursor(Point point) {
        StendhalCursor stendhalCursor = null;
        RemovableSprite removableSprite = this.ground.getScreen().getTextAt(point.x, point.y);
        if (removableSprite != null) {
            return StendhalCursor.NORMAL;
        }
        Point2D point2D = this.ground.getScreen().convertScreenViewToWorld(point);
        EntityView<?> entityView = this.ground.getScreen().getEntityViewAt(point2D.getX(), point2D.getY());
        if (entityView != null) {
            stendhalCursor = entityView.getCursor();
        }
        if (stendhalCursor == null) {
            stendhalCursor = StendhalCursor.WALK;
            StaticGameLayers staticGameLayers = this.ground.getClient().getStaticGameLayers();
            if (staticGameLayers.getCollisionDetection() != null && staticGameLayers.getCollisionDetection().collides((int)point2D.getX(), (int)point2D.getY())) {
                stendhalCursor = StendhalCursor.STOP;
            } else if (this.ground.calculateZoneChangeDirection(point2D) != null) {
                stendhalCursor = StendhalCursor.WALK_BORDER;
            }
        }
        return stendhalCursor;
    }
}

