/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.gui.LinearScalingModel;
import games.stendhal.client.gui.StatusDisplayBar;
import java.awt.Color;
import java.awt.Dimension;

public class HPIndicator
extends StatusDisplayBar {
    private static final int DEFAULT_HEIGHT = 6;

    public HPIndicator() {
        super(new LinearScalingModel());
        this.setBackground(Color.DARK_GRAY);
        this.setForeground(Color.WHITE);
        this.setPreferredSize(new Dimension(0, 6));
        this.setMinimumSize(this.getPreferredSize());
    }

    public void setRatio(float f) {
        if (f > 1.0f) {
            f = 1.0f;
        }
        float f2 = Math.min((1.0f - f) * 2.0f, 1.0f);
        float f3 = Math.min(f * 2.0f, 1.0f);
        this.setBarColor(new Color(f2, f3, 0.0f));
        this.getModel().setValue(f);
    }

    public void setHP(int n, int n2) {
        float f = (float)n2 / (float)n;
        this.setRatio(f);
    }
}

