/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.gui.AbstractScalingModel;
import games.stendhal.client.gui.StatusDisplayBar;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public final class KarmaIndicator
extends StatusDisplayBar
implements PropertyChangeListener {
    private static final long serialVersionUID = 3462088641737184898L;
    private static final int HIGHLIGHT_TIME = 1000;
    private static KarmaIndicator instance;
    private final Timer timer;

    static synchronized KarmaIndicator create() {
        if (instance != null) {
            throw new IllegalStateException("Instance already created");
        }
        instance = new KarmaIndicator();
        return instance;
    }

    private KarmaIndicator() {
        super(new KarmaScalingModel());
        this.setPainter(new KarmaBarPainter());
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KarmaIndicator.this.setForeground(Color.BLACK);
            }
        });
        this.timer.setRepeats(false);
        this.setVisible(false);
    }

    public static KarmaIndicator get() {
        if (instance == null) {
            throw new IllegalStateException("KarmaIndicator not initialized");
        }
        return instance;
    }

    void setValue(double d) {
        this.setToolTipText(this.describeKarma(d));
        this.getModel().setValue(d);
    }

    private String describeKarma(double d) {
        if (d > 499.0) {
            return "Masz niesamowicie dobr\u0105 karm\u0119";
        }
        if (d > 99.0) {
            return "Masz wspania\u0142\u0105 karm\u0119";
        }
        if (d > 5.0) {
            return "Masz dobr\u0105 karm\u0119";
        }
        if (d > -5.0) {
            return "Masz \u015bredni\u0105 karm\u0119";
        }
        if (d > -99.0) {
            return "Masz z\u0142\u0105 karm\u0119";
        }
        if (d > -499.0) {
            return "Masz straszn\u0105 karm\u0119";
        }
        return "Masz katastrofalnie z\u0142\u0105 karm\u0119";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Map map;
        if (propertyChangeEvent == null) {
            return;
        }
        Map map2 = (Map)propertyChangeEvent.getOldValue();
        if (map2 != null && map2.containsKey("karma_indicator")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KarmaIndicator.this.setVisible(false);
                }
            });
        }
        if ((map = (Map)propertyChangeEvent.getNewValue()) != null && map.containsKey("karma_indicator")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KarmaIndicator.this.setVisible(true);
                }
            });
        }
    }

    @Override
    protected void valueChanged() {
        if (((KarmaScalingModel)this.getModel()).isTrueChange()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KarmaIndicator.this.setForeground(Color.WHITE);
                    KarmaIndicator.this.timer.restart();
                }
            });
        } else {
            this.repaint();
        }
    }

    private static class KarmaScalingModel
    extends AbstractScalingModel {
        private static final double SCALING = 0.02;
        private int maxRepresentation = 1;
        private double value;
        boolean realChange;

        private KarmaScalingModel() {
        }

        @Override
        public void setValue(double d) {
            this.realChange = this.value != d;
            this.value = d;
            if (!this.calculateRepresentation() && this.realChange) {
                this.fireChanged();
            }
        }

        private boolean calculateRepresentation() {
            double d = 0.5 + Math.atan(0.02 * this.value) / Math.PI;
            return this.setRepresentation((int)Math.round(d * (double)this.maxRepresentation));
        }

        boolean isTrueChange() {
            return this.realChange;
        }

        @Override
        public void setMaxRepresentation(int n) {
            if (this.maxRepresentation != n) {
                this.maxRepresentation = n;
                this.setValue(this.value);
            }
        }
    }

    private static class KarmaBarPainter
    implements StatusDisplayBar.BarPainter {
        private KarmaBarPainter() {
        }

        @Override
        public void paint(Graphics2D graphics2D, int n, int n2) {
            Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float float_2 = new Point2D.Float(n, 0.0f);
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(float_, float_2, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{Color.RED, Color.WHITE, Color.BLUE});
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fillRect(0, 0, n, n2);
        }
    }
}

