/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import java.awt.Toolkit;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;

public class StyledLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = -3834174297983517102L;
    private static final String pkg = "games.stendhal.client.gui.styled.";
    private final Style style;

    public StyledLookAndFeel(Style style) {
        this.style = style;
    }

    @Override
    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        Object[] objectArray = new Object[]{"StendhalStyle", this.style, "ButtonUI", "games.stendhal.client.gui.styled.StyledButtonUI", "CheckBoxUI", "games.stendhal.client.gui.styled.StyledCheckBoxUI", "ComboBoxUI", "games.stendhal.client.gui.styled.StyledComboBoxUI", "LabelUI", "games.stendhal.client.gui.styled.StyledLabelUI", "MenuItemUI", "games.stendhal.client.gui.styled.StyledMenuItemUI", "OptionPaneUI", "games.stendhal.client.gui.styled.StyledOptionPaneUI", "PanelUI", "games.stendhal.client.gui.styled.StyledPanelUI", "PasswordFieldUI", "games.stendhal.client.gui.styled.StyledPasswordFieldUI", "PopupMenuUI", "games.stendhal.client.gui.styled.StyledPopupMenuUI", "ProgressBarUI", "games.stendhal.client.gui.styled.StyledProgressBarUI", "SeparatorUI", "games.stendhal.client.gui.styled.StyledSeparatorUI", "ScrollBarUI", "games.stendhal.client.gui.styled.StyledScrollBarUI", "ScrollPaneUI", "games.stendhal.client.gui.styled.StyledScrollPaneUI", "SliderUI", "games.stendhal.client.gui.styled.StyledSliderUI", "SpinnerUI", "games.stendhal.client.gui.styled.StyledSpinnerUI", "SplitPaneUI", "games.stendhal.client.gui.styled.StyledSplitPaneUI", "TabbedPaneUI", "games.stendhal.client.gui.styled.StyledTabbedPaneUI", "TableUI", "games.stendhal.client.gui.styled.StyledTableUI", "TextFieldUI", "games.stendhal.client.gui.styled.StyledTextFieldUI", "ToolTipUI", "games.stendhal.client.gui.styled.StyledToolTipUI"};
        uIDefaults.putDefaults(objectArray);
    }

    public void setDefaultFontSize(int n) {
        UIDefaults uIDefaults = this.getDefaults();
        for (Object k : uIDefaults.keySet()) {
            if (!(k instanceof String) || !((String)k).endsWith(".font")) continue;
            FontUIResource fontUIResource = (FontUIResource)uIDefaults.get(k);
            UIManager.put(k, new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle(), n));
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        this.restoreSystemKeymaps(uIDefaults);
    }

    private void restoreSystemKeymaps(UIDefaults uIDefaults) {
        String[] stringArray = new String[]{"EditorPane.focusInputMap", "FormattedTextField.focusInputMap", "PasswordField.focusInputMap", "TextArea.focusInputMap", "TextField.focusInputMap", "TextPane.focusInputMap"};
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        for (String string : stringArray) {
            Object object = uIDefaults.get(string);
            if (object instanceof InputMapUIResource) {
                InputMapUIResource inputMapUIResource = (InputMapUIResource)object;
                this.remapKey(inputMapUIResource, 88, 128, n);
                this.remapKey(inputMapUIResource, 67, 128, n);
                this.remapKey(inputMapUIResource, 86, 128, n);
                this.remapKey(inputMapUIResource, 65, 128, n);
                continue;
            }
            Logger.getLogger(StyledLookAndFeel.class).error((Object)("Can not modify resource: " + string));
        }
    }

    private void remapKey(InputMapUIResource inputMapUIResource, int n, int n2, int n3) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        Object object = inputMapUIResource.get(keyStroke);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(n, n3);
        if (!keyStroke2.equals(keyStroke)) {
            inputMapUIResource.remove(keyStroke);
            inputMapUIResource.put(keyStroke2, object);
        }
    }

    @Override
    public String getDescription() {
        return "PolanieOnLine pixmap look and feel";
    }

    @Override
    public String getID() {
        return "PolanieOnLine";
    }

    @Override
    public String getName() {
        return "PolanieOnLine";
    }
}

