/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled.cursor;

import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.DataLoader;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class CursorRepository {
    private static Logger logger = Logger.getLogger(CursorRepository.class);
    private Map<StendhalCursor, Cursor> cursorMap = new EnumMap<StendhalCursor, Cursor>(StendhalCursor.class);

    public Cursor get(StendhalCursor stendhalCursor) {
        Cursor cursor = this.cursorMap.get((Object)stendhalCursor);
        if (cursor == null) {
            cursor = this.loadCursor(stendhalCursor);
        }
        return cursor;
    }

    private Cursor loadCursor(StendhalCursor stendhalCursor) {
        BufferedImage bufferedImage;
        String string;
        URL uRL;
        String string2 = "data/sprites/cursor/";
        if (WtWindowManager.getInstance().getPropertyBoolean("gamescreen.cursorclassic", true)) {
            string2 = string2 + "classic/";
        }
        if ((uRL = DataLoader.getResource(string = string2 + stendhalCursor.getImageName() + ".png")) == null) {
            logger.error((Object)("Can't find image: " + string), new Throwable());
            this.cursorMap.put(stendhalCursor, Cursor.getDefaultCursor());
            return Cursor.getDefaultCursor();
        }
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            logger.error((Object)("Can't read image: " + string), new Throwable());
            this.cursorMap.put(stendhalCursor, Cursor.getDefaultCursor());
            return Cursor.getDefaultCursor();
        }
        Point point = stendhalCursor.getHotSpot();
        String string3 = stendhalCursor.toString().toLowerCase(Locale.ENGLISH);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(bufferedImage, point, string3);
        this.cursorMap.put(stendhalCursor, cursor);
        return cursor;
    }
}

