/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.wt.core;

import games.stendhal.client.gui.ManagedWindow;
import games.stendhal.client.gui.wt.core.SettingChangeListener;
import games.stendhal.client.stendhal;
import games.stendhal.common.MathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import marauroa.common.io.Persistence;
import org.apache.log4j.Logger;

public final class WtWindowManager {
    private static final Logger logger = Logger.getLogger(WtWindowManager.class);
    private static final String FILE_NAME = "windows.properties";
    private Properties properties;
    private static WtWindowManager instance;
    private final Map<String, WindowConfiguration> configs = new HashMap<String, WindowConfiguration>();
    private final Map<String, List<SettingChangeListener>> listeners = new HashMap<String, List<SettingChangeListener>>();

    private WtWindowManager() {
        this.read();
    }

    public static synchronized WtWindowManager getInstance() {
        if (instance == null) {
            instance = new WtWindowManager();
        }
        return instance;
    }

    public void setDefaultProperties(String string, boolean bl, int n, int n2) {
        if (!this.configs.containsKey(string)) {
            WindowConfiguration windowConfiguration = new WindowConfiguration(string);
            windowConfiguration.readFromProperties(this.properties, bl, n, n2, true);
            this.configs.put(string, windowConfiguration);
        }
    }

    public void save() {
        StringBuilder stringBuilder = new StringBuilder();
        for (WindowConfiguration object : this.configs.values()) {
            stringBuilder.append(object.writeToPropertyString());
        }
        for (Object object : this.properties.keySet()) {
            if (!object.toString().startsWith("config.")) continue;
            stringBuilder.append(object.toString() + "=" + this.properties.get(object) + "\n");
        }
        try (OutputStream outputStream = Persistence.get().getOutputStream(false, stendhal.getGameFolder(), FILE_NAME);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "ISO-8859-1");){
            outputStreamWriter.append(stringBuilder.toString());
        }
        catch (IOException iOException) {
            logger.error((Object)("Can't write " + stendhal.getGameFolder() + FILE_NAME), (Throwable)iOException);
        }
    }

    private void read() {
        this.properties = new Properties();
        try {
            InputStream inputStream = Persistence.get().getInputStream(false, stendhal.getGameFolder(), FILE_NAME);
            this.properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private WindowConfiguration getConfig(ManagedWindow managedWindow) {
        String string = managedWindow.getName();
        WindowConfiguration windowConfiguration = this.configs.get(string);
        if (windowConfiguration == null) {
            windowConfiguration = new WindowConfiguration(string);
            windowConfiguration.readFromProperties(this.properties, managedWindow);
            this.configs.put(string, windowConfiguration);
        }
        return windowConfiguration;
    }

    public String getProperty(String string, String string2) {
        return this.properties.getProperty("config." + string, string2);
    }

    public int getPropertyInt(String string, int n) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return n;
        }
        return MathHelper.parseIntDefault(string2, n);
    }

    public boolean getPropertyBoolean(String string, boolean bl) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return bl;
        }
        return Boolean.parseBoolean(string2);
    }

    public void registerSettingChangeListener(String string, SettingChangeListener settingChangeListener) {
        String string2 = "config." + string;
        List<SettingChangeListener> list = this.listeners.get(string2);
        if (list == null) {
            list = new ArrayList<SettingChangeListener>();
            this.listeners.put(string2, list);
        }
        list.add(settingChangeListener);
    }

    public void deregisterSettingChangeListener(String string, SettingChangeListener settingChangeListener) {
        List<SettingChangeListener> list = this.listeners.get("config. " + string);
        if (list != null) {
            list.remove(settingChangeListener);
        }
    }

    public void setProperty(String string, String string2) {
        String string3 = "config." + string;
        this.properties.setProperty(string3, string2);
        List<SettingChangeListener> list = this.listeners.get(string3);
        if (list != null) {
            for (SettingChangeListener settingChangeListener : list) {
                settingChangeListener.changed(string2);
            }
        }
    }

    public void formatWindow(ManagedWindow managedWindow) {
        WindowConfiguration windowConfiguration = this.getConfig(managedWindow);
        managedWindow.moveTo(windowConfiguration.x, windowConfiguration.y);
        managedWindow.setMinimized(windowConfiguration.minimized);
        managedWindow.setVisible(windowConfiguration.visible);
    }

    public void moveTo(ManagedWindow managedWindow, int n, int n2) {
        WindowConfiguration windowConfiguration = this.getConfig(managedWindow);
        windowConfiguration.x = n;
        windowConfiguration.y = n2;
    }

    public void setMinimized(ManagedWindow managedWindow, boolean bl) {
        WindowConfiguration windowConfiguration = this.getConfig(managedWindow);
        windowConfiguration.minimized = bl;
    }

    private static final class WindowConfiguration {
        private String name;
        private boolean minimized;
        private boolean visible;
        private int x;
        private int y;

        private WindowConfiguration(String string) {
            this.name = string;
        }

        private String writeToPropertyString() {
            return "window." + this.name + ".minimized=" + this.minimized + "\nwindow." + this.name + ".visible=" + this.visible + "\nwindow." + this.name + ".x=" + this.x + "\nwindow." + this.name + ".y=" + this.y + "\n";
        }

        public String toString() {
            return this.writeToPropertyString();
        }

        private void readFromProperties(Properties properties, boolean bl, int n, int n2, boolean bl2) {
            this.minimized = Boolean.parseBoolean(properties.getProperty("window." + this.name + ".minimized", Boolean.toString(bl)));
            this.visible = Boolean.parseBoolean(properties.getProperty("window." + this.name + ".visible", Boolean.toString(bl2)));
            this.x = Integer.parseInt(properties.getProperty("window." + this.name + ".x", Integer.toString(n)));
            this.y = Integer.parseInt(properties.getProperty("window." + this.name + ".y", Integer.toString(n2)));
        }

        private void readFromProperties(Properties properties, ManagedWindow managedWindow) {
            this.readFromProperties(properties, managedWindow.isMinimized(), managedWindow.getX(), managedWindow.getY(), managedWindow.isVisible());
        }
    }
}

