/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.scripting;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.scripting.SlashActionCommand;
import games.stendhal.client.scripting.SlashActionParser;
import games.stendhal.common.NotificationType;
import marauroa.common.game.RPAction;

public abstract class ChatLineParser {
    public static boolean parseAndHandle(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return false;
        }
        if (string2.charAt(0) == '/') {
            SlashActionCommand slashActionCommand = SlashActionParser.parse(string2.substring(1));
            String[] stringArray = slashActionCommand.getParams();
            if (slashActionCommand.hasError()) {
                ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(slashActionCommand.getErrorString(), NotificationType.ERROR));
                return false;
            }
            if (slashActionCommand.getAction() != null) {
                return slashActionCommand.getAction().execute(stringArray, slashActionCommand.getRemainder());
            }
            RPAction rPAction = new RPAction();
            rPAction.put("type", slashActionCommand.getName());
            if (stringArray.length > 0 && stringArray[0] != null) {
                rPAction.put("target", stringArray[0]);
                rPAction.put("args", slashActionCommand.getRemainder());
            }
            ClientSingletonRepository.getClientFramework().send(rPAction);
            return true;
        }
        RPAction rPAction = new RPAction("chat");
        rPAction.put("type", "chat");
        rPAction.put("text", string2);
        ClientSingletonRepository.getClientFramework().send(rPAction);
        return true;
    }
}

