/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound;

import games.stendhal.client.sound.Field;

public class Dsp {
    public static byte[] convertUniformPCM(byte[] byArray, float[] fArray, int n, int n2) {
        int n3 = n2 * 8;
        long l = (long)((Math.pow(2.0, n3) - 1.0) / 2.0);
        byArray = Field.expand(byArray, n2 * n, false);
        for (int i = 0; i < n; ++i) {
            long l2 = (long)(fArray[i] * (float)l);
            int n4 = i * n2;
            l2 = l2 > l ? l : l2;
            l2 = l2 < -l ? -l : l2;
            for (int j = 0; j < n2; ++j) {
                byArray[n4 + j] = (byte)(l2 >>> j * 8);
            }
        }
        return byArray;
    }

    public static void mixAudioData(float[] fArray, int n, float[] fArray2, int n2, int n3, float f) {
        int n4 = n + n3;
        while (n < n4) {
            float f2 = fArray[n];
            float f3 = fArray2[n2] * f;
            fArray[n] = f2 + f3 - f2 * f3;
            ++n;
            ++n2;
        }
    }

    public static void blendAudioData(float[] fArray, int n, float[] fArray2, int n2, int n3, float f) {
        int n4 = n + n3;
        while (n < n4) {
            float f2 = fArray[n];
            float f3 = fArray2[n2];
            fArray[n] = f2 + (f3 - f2) * f;
            ++n;
            ++n2;
        }
    }

    public static float[] convertChannels(float[] fArray, int n, int n2, int n3) {
        if (n2 == n3) {
            return fArray;
        }
        if (n2 > n3) {
            if (n3 == 1) {
                for (int i = 0; i < n; ++i) {
                    int n4 = i * n2;
                    float f = 0.0f;
                    for (int j = 0; j < n2; ++j) {
                        f += fArray[n4 + j];
                    }
                    fArray[i] = f / (float)n2;
                }
            } else {
                fArray = null;
            }
        } else if (n2 == 1) {
            float[] fArray2 = new float[n * n3];
            for (int i = 0; i < n; ++i) {
                int n5 = i * n3;
                for (int j = 0; j < n3; ++j) {
                    fArray2[n5 + j] = fArray[i];
                }
            }
            fArray = fArray2;
        } else {
            fArray = null;
        }
        return fArray;
    }

    public static float[] convertSampleRate(float[] fArray, int n, int n2, int n3, int n4) {
        float[] fArray2;
        assert (fArray.length >= n * n2);
        assert (n2 > 0);
        assert (n3 > 0);
        assert (n4 > 0);
        if (n3 == n4) {
            fArray2 = fArray;
        } else {
            double d = (double)n3 / (double)n4;
            int n5 = (int)((double)n / d);
            int n6 = n5 * n2;
            fArray2 = new float[n6];
            int n7 = 0;
            for (int i = 0; i < n5; ++i) {
                int n8 = (int)((double)i * d);
                for (int j = 0; j < n2; ++j) {
                    fArray2[n7++] = fArray[n8 * n2 + j];
                }
            }
            assert (n7 == n6);
        }
        return fArray2;
    }
}

