/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system.processors;

import games.stendhal.client.sound.Field;
import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.common.math.Algebra;

public class DirectedSound
extends SignalProcessor {
    private final float[] mUpVector = new float[]{0.0f, 1.0f, 0.0f};
    private float mIntensity = 1.0f;
    private float mLVolume = 1.0f;
    private float mRVolume = 1.0f;
    private float[] mOutputBuffer = null;

    public DirectedSound() {
    }

    public DirectedSound(float[] fArray) {
        assert (fArray.length == 3);
        Algebra.mov_Vecf(this.mUpVector, fArray);
    }

    public synchronized void setUpVector(float[] fArray) {
        assert (fArray.length == 3);
        Algebra.mov_Vecf(this.mUpVector, fArray);
    }

    public synchronized void setPositions3D(float[] fArray, float[] fArray2, float[] fArray3, float f) {
        if (Algebra.isEqual_Vecf(fArray, fArray2)) {
            this.mRVolume = f;
            this.mLVolume = f;
            this.mIntensity = f;
            return;
        }
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        Algebra.sub_Vecf(fArray4, fArray, fArray2);
        Algebra.cross_Vec3f(fArray5, fArray3, this.mUpVector);
        Algebra.normalize_Vecf(fArray4, fArray4);
        Algebra.normalize_Vecf(fArray5, fArray5);
        float f2 = Algebra.dot_Vecf(fArray5, fArray4);
        this.mLVolume = Math.min(1.0f - f2, 1.0f);
        this.mRVolume = Math.min(1.0f + f2, 1.0f);
        this.mLVolume += (1.0f - this.mLVolume) * f;
        this.mRVolume += (1.0f - this.mRVolume) * f;
        this.mIntensity = f;
    }

    public synchronized void setPositions2D(float[] fArray, float[] fArray2, float[] fArray3, float f) {
        if (Algebra.isEqual_Vecf(fArray, fArray2)) {
            this.mRVolume = f;
            this.mLVolume = f;
            this.mIntensity = f;
            return;
        }
        float[] fArray4 = new float[2];
        float[] fArray5 = new float[2];
        Algebra.sub_Vecf(fArray4, fArray, fArray2);
        Algebra.cross_Vec2f(fArray5, fArray3);
        Algebra.normalize_Vecf(fArray4, fArray4);
        Algebra.normalize_Vecf(fArray5, fArray5);
        float f2 = Algebra.dot_Vecf(fArray5, fArray4);
        this.mLVolume = Math.min(1.0f - f2, 1.0f);
        this.mRVolume = Math.min(1.0f + f2, 1.0f);
        this.mLVolume += (1.0f - this.mLVolume) * (f * f);
        this.mRVolume += (1.0f - this.mRVolume) * (f * f);
        this.mIntensity = f;
    }

    @Override
    protected synchronized void modify(float[] fArray, int n, int n2, int n3) {
        assert (n2 > 0 && n2 <= 2);
        assert (fArray.length >= n * n2);
        if (n2 == 1) {
            this.mOutputBuffer = Field.expand(this.mOutputBuffer, n * 2, false);
            for (int i = 0; i < n; ++i) {
                this.mOutputBuffer[i * 2 + 0] = fArray[i] * this.mLVolume;
                this.mOutputBuffer[i * 2 + 1] = fArray[i] * this.mRVolume;
            }
            fArray = this.mOutputBuffer;
            n2 = 2;
        } else {
            for (int i = 0; i < n; ++i) {
                float f = fArray[i * 2 + 0];
                float f2 = fArray[i * 2 + 1];
                float f3 = (f + f2) / 2.0f;
                f += (f3 - f) * this.mIntensity;
                f2 += (f3 - f2) * this.mIntensity;
                fArray[i * 2 + 0] = f *= this.mLVolume;
                fArray[i * 2 + 1] = f2 *= this.mRVolume;
            }
        }
        super.propagate(fArray, n, n2, n3);
    }
}

