/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system.processors;

import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.system.SignalProcessor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Interruptor
extends SignalProcessor {
    private static final int PLAY = 0;
    private static final int STOP = 1;
    private static final int PAUSE = 2;
    private AtomicInteger mState = new AtomicInteger(0);
    private AtomicLong mDelay = new AtomicLong(0L);

    public void play() {
        this.mState.set(0);
        this.mDelay.set(0L);
    }

    public void pause(Time time) {
        this.mState.set(2);
        this.mDelay.set(time.getInNanoSeconds());
    }

    public void stop(Time time) {
        this.mState.set(1);
        this.mDelay.set(time.getInNanoSeconds());
    }

    @Override
    public synchronized boolean request() {
        if (this.mDelay.get() <= 0L) {
            switch (this.mState.get()) {
                case 2: {
                    return true;
                }
                case 1: {
                    this.quit();
                    return false;
                }
            }
        }
        return super.request();
    }

    @Override
    protected void modify(float[] fArray, int n, int n2, int n3) {
        if (this.mState.get() != 0) {
            Time time = new Time((long)n, n3);
            this.mDelay.addAndGet(-time.getInNanoSeconds());
        }
        super.propagate(fArray, n, n2, n3);
    }
}

