/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.TileSprite;
import java.awt.Graphics;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class AnimatedSprite
implements Sprite {
    private static Logger logger = Logger.getLogger(AnimatedSprite.class);
    private Object reference;
    private boolean animating;
    private int cycleTime;
    protected int[] delays;
    private int duration;
    private int index;
    protected Sprite[] frames;
    private int height;
    protected long lastUpdate;
    protected boolean loop;
    protected Sprite sprite;
    private int width;

    AnimatedSprite(Sprite[] spriteArray, int n) {
        this(spriteArray, n, true);
    }

    public AnimatedSprite(Sprite[] spriteArray, int n, boolean bl) {
        this(spriteArray, n, bl, null);
    }

    private AnimatedSprite(Sprite[] spriteArray, int n, boolean bl, Object object) {
        this(spriteArray, AnimatedSprite.createDelays(n, spriteArray.length), bl, object);
    }

    AnimatedSprite(Sprite[] spriteArray, int[] nArray, boolean bl, Object object) {
        if (spriteArray.length == 0) {
            logger.warn((Object)"AnimatedSprite needs at least one frame");
        }
        if (nArray.length != spriteArray.length) {
            throw new IllegalArgumentException("Mismatch between number of frame sprites and delays");
        }
        this.duration = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                throw new IllegalArgumentException("Delay < 0");
            }
            this.duration += nArray[i];
        }
        this.frames = spriteArray;
        this.delays = nArray;
        this.animating = bl;
        this.reference = object;
        this.loop = true;
        this.height = 0;
        this.width = 0;
        for (Sprite sprite : spriteArray) {
            this.height = Math.max(this.height, sprite.getHeight());
            this.width = Math.max(this.width, sprite.getWidth());
        }
        this.index = 0;
        this.sprite = spriteArray.length > 0 ? spriteArray[0] : null;
        this.cycleTime = 0;
        long l = System.currentTimeMillis();
        this.lastUpdate = this.loop ? l - l % (long)this.duration : l;
    }

    private static int[] createDelays(int n, int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, n);
        return nArray;
    }

    public void reset(int n) {
        this.setIndex(n);
    }

    private void setIndex(int n) {
        if (n < 0 || n >= this.frames.length) {
            throw new ArrayIndexOutOfBoundsException("Invalid index: " + n);
        }
        this.index = n;
        this.sprite = this.frames[n];
        this.cycleTime = 0;
        for (int i = 0; i < n; ++i) {
            this.cycleTime += this.delays[i];
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void start() {
        this.animating = true;
    }

    public void stop() {
        this.animating = false;
    }

    private void update() {
        long l = System.currentTimeMillis();
        this.update((int)(l - this.lastUpdate));
        this.lastUpdate = l;
    }

    @Override
    public Sprite createRegion(int n, int n2, int n3, int n4, Object object) {
        return new TileSprite(this, n, n2, n3, n4, object);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        this.update();
        if (this.sprite != null) {
            this.sprite.draw(graphics, n, n2);
        }
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.update();
        if (this.sprite != null) {
            this.sprite.draw(graphics, n, n2, n3, n4, n5, n6);
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    private void update(int n) {
        if (this.animating) {
            this.cycleTime += n;
            if (this.loop) {
                this.cycleTime %= this.duration;
            }
            while (this.cycleTime >= this.delays[this.index]) {
                this.cycleTime -= this.delays[this.index];
                if (++this.index != this.frames.length) continue;
                this.index = 0;
                if (this.loop) continue;
                this.sprite = null;
                this.animating = false;
                return;
            }
            this.sprite = this.frames[this.index];
        }
    }
}

