/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.util.JSONLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

public class EmojiStore {
    private static EmojiStore instance;
    private List<String> emojilist = new LinkedList<String>();
    private Map<String, String> emojimap = new HashMap<String, String>();
    private static final String pathPrefix = "data/sprites/emoji/";
    @Deprecated
    public static final Map<String, String> chatLogChars;

    public static EmojiStore get() {
        if (instance == null) {
            instance = new EmojiStore();
        }
        return instance;
    }

    private EmojiStore() {
    }

    public void init() {
        final JSONLoader jSONLoader = new JSONLoader();
        jSONLoader.onDataReady = new Runnable(){

            @Override
            public void run() {
                JSONObject jSONObject = (JSONObject)jSONLoader.data;
                Object object = jSONObject.get((Object)"emojilist");
                Object object2 = jSONObject.get((Object)"emojimap");
                if (object != null && object instanceof List) {
                    for (Object object3 : (List)object) {
                        EmojiStore.this.emojilist.add((String)object3);
                    }
                }
                if (object2 != null && object2 instanceof Map) {
                    for (Map.Entry entry : ((Map)object2).entrySet()) {
                        EmojiStore.this.emojimap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
        };
        jSONLoader.load("data/sprites/emoji/emojis.json");
    }

    public Sprite create(String string) {
        String string2 = this.absPath(string);
        if (string2 == null) {
            return null;
        }
        return ClientSingletonRepository.getSpriteStore().getSprite(string2);
    }

    public String check(String string) {
        String string2;
        String string3 = string2 = this.emojimap.containsKey(string = string.replace("\\\\", "\\")) ? this.emojimap.get(string) : null;
        if (string2 == null && string.startsWith(":") && string.endsWith(":") && this.isAvailable(string = string.substring(0, string.length() - 1).substring(1))) {
            string2 = string;
        }
        return string2;
    }

    public String absPath(String string) {
        String string2 = this.check(string);
        if (string2 != null) {
            return pathPrefix + string2 + ".png";
        }
        return null;
    }

    public boolean isAvailable(String string) {
        if (string.startsWith(":") && string.endsWith(":")) {
            string = string.substring(1, string.length() - 1);
        }
        return this.emojilist.contains(string);
    }

    public List<String> getEmojiList() {
        return new LinkedList<String>(){
            {
                this.addAll(EmojiStore.this.emojilist);
            }
        };
    }

    static {
        chatLogChars = new HashMap<String, String>(){};
    }
}

