/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import games.stendhal.client.sprite.Sprite;
import java.awt.Graphics;

class TileSprite
implements Sprite {
    private Object reference;
    private Sprite sprite;
    private int height;
    private int width;
    private int x;
    private int y;

    TileSprite(Sprite sprite, int n, int n2, int n3, int n4, Object object) {
        this.sprite = sprite;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.reference = object;
    }

    static TSRef createReference(Sprite sprite, int n, int n2, int n3, int n4) {
        Object object = sprite.getReference();
        if (object == null) {
            return null;
        }
        return new TSRef(object, n, n2, n3, n4);
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    @Override
    public Sprite createRegion(int n, int n2, int n3, int n4, Object object) {
        return new TileSprite(this, n, n2, n3, n4, object);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2) {
        this.sprite.draw(graphics, n, n2, this.x, this.y, this.width, this.height);
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.sprite.draw(graphics, n, n2, n3 + this.x, n4 + this.y, Math.min(n5, this.width), Math.min(n6, this.height));
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean isConstant() {
        return this.sprite.isConstant();
    }

    protected static class TSRef {
        private Object parent;
        private int x;
        private int y;
        private int width;
        private int height;

        private TSRef(Object object, int n, int n2, int n3, int n4) {
            this.parent = object;
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof TSRef) {
                TSRef tSRef = (TSRef)object;
                if (!this.parent.equals(tSRef.parent)) {
                    return false;
                }
                return this.x == tSRef.x && this.y == tSRef.y && this.width == tSRef.width && this.height == tSRef.height;
            }
            return false;
        }

        public int hashCode() {
            return this.parent.hashCode() ^ this.x ^ this.y;
        }

        public String toString() {
            return this.parent + "[" + this.x + "," + this.y + "/" + this.width + "x" + this.height + "]";
        }
    }
}

