/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.util;

import games.stendhal.client.sprite.DataLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;
import org.json.simple.JSONValue;

public class JSONLoader
extends DataLoader {
    private static final Logger logger = Logger.getLogger(JSONLoader.class);
    public Object data;
    public Runnable onDataReady;

    public JSONLoader() {
    }

    public JSONLoader(Runnable runnable) {
        this.onDataReady = runnable;
    }

    public void load(String string) {
        URL uRL = JSONLoader.getResource(string);
        if (uRL != null) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), StandardCharsets.UTF_8);
                this.data = JSONValue.parse((Reader)inputStreamReader);
                if (this.data == null) {
                    logger.error((Object)("Failed to read JSON data file: " + string));
                } else if (this.onDataReady != null) {
                    this.onDataReady.run();
                }
            }
            catch (IOException iOException) {
                logger.error((Object)("Error loading JSON data from file: " + string), (Throwable)iOException);
            }
        }
    }
}

