/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class Line {
    public static List<Point> renderLine(int n, int n2, int n3, int n4) {
        State state = new State(n, n2, n3, n4);
        final ArrayList<Point> arrayList = new ArrayList<Point>(state.steps);
        Line.renderLine(n, n2, state, new Action(){

            @Override
            public void fire(int n, int n2) {
                arrayList.add(new Point(n, n2));
            }
        });
        return arrayList;
    }

    public static void renderLine(int n, int n2, int n3, int n4, Action action) {
        State state = new State(n, n2, n3, n4);
        Line.renderLine(n, n2, state, action);
    }

    private static void renderLine(int n, int n2, State state, Action action) {
        int n3 = n;
        int n4 = n2;
        for (int i = 1; i <= state.steps + 1; ++i) {
            action.fire(n3, n4);
            n3 = n + state.deltax * i / state.steps;
            n4 = n2 + state.deltay * i / state.steps;
        }
    }

    private static final class State {
        final int deltay;
        final int deltax;
        final int steps;

        State(int n, int n2, int n3, int n4) {
            this.deltay = n4 - n2;
            this.deltax = n3 - n;
            this.steps = Math.max(Math.abs(this.deltax), Math.abs(this.deltay));
        }
    }

    public static abstract class Action {
        public abstract void fire(int var1, int var2);
    }
}

