/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringFormatter {
    private static final String PARAMETER_START = "${";
    private static final String PARAMETER_END = "}";
    private boolean refreshCache;
    private String cachedString;
    private final List<String> staticParts = new ArrayList<String>();
    private final List<String> parameterPositions = new ArrayList<String>();
    private final Map<String, String> parameter = new HashMap<String, String>();

    public StringFormatter(String string) {
        int n;
        String string2 = string;
        boolean bl = false;
        do {
            String string3;
            if ((n = bl ? string2.indexOf(PARAMETER_END) : string2.indexOf(PARAMETER_START)) < 0) continue;
            if (bl) {
                string3 = string2.substring(PARAMETER_START.length(), n);
                string2 = string2.substring(n + PARAMETER_END.length());
                this.parameter.put(string3, "");
                this.parameterPositions.add(string3);
            } else {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n);
                this.staticParts.add(string3);
            }
            boolean bl2 = bl = !bl;
        } while (n >= 0);
        this.staticParts.add(string2);
    }

    public void set(String string, String string2) {
        if (this.parameter.containsKey(string)) {
            this.parameter.put(string, string2);
            this.refreshCache = true;
        }
    }

    public void set(String string, int n) {
        if (this.parameter.containsKey(string)) {
            this.parameter.put(string, Integer.toString(n));
            this.refreshCache = true;
        }
    }

    public String toString() {
        if (this.cachedString == null || this.refreshCache) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = this.staticParts.iterator();
            Iterator<String> iterator2 = this.parameterPositions.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (!iterator2.hasNext()) continue;
                stringBuilder.append(this.parameter.get(iterator2.next()));
            }
            this.cachedString = stringBuilder.toString();
        }
        return this.cachedString;
    }
}

