/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.grammar;

import games.stendhal.common.grammar.Grammar;
import games.stendhal.common.grammar.ItemParserResult;
import games.stendhal.common.parser.Expression;
import games.stendhal.common.parser.NameSearch;
import games.stendhal.common.parser.Sentence;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ItemParser {
    protected Set<String> itemNames;

    public ItemParser() {
        this.itemNames = new HashSet<String>();
    }

    public ItemParser(Set<String> set) {
        this.itemNames = set;
    }

    public ItemParser(String string) {
        this.itemNames = new HashSet<String>();
        this.itemNames.add(string);
    }

    public Set<String> getItemNames() {
        return this.itemNames;
    }

    public ItemParserResult parse(Sentence sentence) {
        Set<String> set = this.getItemNames();
        if (set.isEmpty()) {
            String string;
            int n;
            List<Expression> list = sentence.getExpressions();
            if (list.size() == 1) {
                Expression expression = list.get(0);
                n = expression.getAmount();
                string = expression.getNormalized();
            } else {
                Expression expression = sentence.getNumeral();
                n = expression != null ? expression.getAmount() : 1;
                string = sentence.getExpressionStringAfterVerb();
            }
            return new ItemParserResult(false, string, n, null);
        }
        NameSearch nameSearch = sentence.findMatchingName(set);
        boolean bl = nameSearch.found();
        String string = nameSearch.getName();
        int n = nameSearch.getAmount();
        HashSet<String> hashSet = null;
        if (!bl) {
            if (sentence.getNumeralCount() == 1 && sentence.getUnknownTypeCount() == 0 && sentence.getObjectCount() == 0) {
                Expression expression = sentence.getNumeral();
                n = expression.getAmount();
            } else {
                string = sentence.getExpressionStringAfterVerb();
                n = 1;
            }
            if (string == null && set.size() == 1) {
                string = set.iterator().next();
                bl = true;
            } else if (string != null) {
                hashSet = new HashSet<String>();
                for (String string2 : set) {
                    if (!string2.endsWith(" " + string) && !string2.startsWith(string + " ")) continue;
                    hashSet.add(string2);
                }
            }
        }
        return new ItemParserResult(bl, string, n, hashSet);
    }

    public String getErrormessage(ItemParserResult itemParserResult, List<String> list, String string) {
        String string2 = itemParserResult.getChosenItemName();
        Set<String> set = itemParserResult.getMayBeItems();
        if (string.equals("produce")) {
            string = "produkuj\u0119";
        } else if (string.equals("buy")) {
            string = "skupuj\u0119";
        } else if (string.equals("sell")) {
            string = "sprzedaj\u0119";
        } else if (string.equals("repair")) {
            string = "naprawiam";
        } else if (string.equals("heal")) {
            string = "lecz\u0119";
        }
        if (string2 == null) {
            return "Powiedz mi co chcesz zrobi\u0107.";
        }
        if (set != null && set.size() > 1) {
            return "Jest wi\u0119cej ni\u017c jeden " + string2 + ". Powiedz mi jaki rodzaj " + string2 + " chcesz u\u017cy\u0107.";
        }
        if (set != null && !set.isEmpty()) {
            return "Powiedz mi jaki rodzaj " + string2 + " chcesz u\u017cy\u0107.";
        }
        return "Nie " + string + " " + Grammar.plural(string2) + ".";
    }
}

