/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.grammar;

import games.stendhal.common.grammar.Grammar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class PrefixManager {
    public static PrefixManager s_instance = new PrefixManager();
    private Collection<String> pluralPrefixes = new HashSet<String>();
    private Collection<PrefixEntry> prefixEndList = new ArrayList<PrefixEntry>();
    private Collection<PrefixEntry> prefixStartList = new ArrayList<PrefixEntry>();
    private Map<String, PrefixEntry> prefixMap = new HashMap<String, PrefixEntry>();
    private Collection<String> singularPrefixes = new HashSet<String>();

    public PrefixManager() {
        this.register("", "", "");
        this.registerStart("", "", "");
        this.registerEnd("", "", "");
    }

    public String fullForm(String string, String string2) {
        String string3 = string2;
        PrefixEntry prefixEntry = this.prefixMap.get(string);
        if (prefixEntry != null) {
            string3 = prefixEntry.prefixSingular + string3;
        } else {
            for (PrefixEntry prefixEntry2 : this.prefixEndList) {
                if (!string.endsWith(prefixEntry2.keyword)) continue;
                string3 = Grammar.addPrefixIfNotAlreadyThere(string3, prefixEntry2.prefixSingular, prefixEntry2.prefixPlural);
                break;
            }
            for (PrefixEntry prefixEntry2 : this.prefixStartList) {
                if (!string.startsWith(prefixEntry2.keyword)) continue;
                string3 = Grammar.addPrefixIfNotAlreadyThere(string3, prefixEntry2.prefixSingular, prefixEntry2.prefixPlural);
                break;
            }
        }
        return string3;
    }

    public Collection<String> getPluralPrefixes() {
        return this.pluralPrefixes;
    }

    public Collection<String> getSingularPrefixes() {
        return this.singularPrefixes;
    }

    private void register(String string, String string2, String string3) {
        this.prefixMap.put(string3, new PrefixEntry(string3, string, string2));
        this.registerPrefix(string, string2);
    }

    private void registerEnd(String string, String string2, String string3) {
        this.prefixEndList.add(new PrefixEntry(string3, string, string2));
        this.registerPrefix(string, string2);
    }

    private void registerStart(String string, String string2, String string3) {
        this.prefixStartList.add(new PrefixEntry(string3, string, string2));
        this.registerPrefix(string, string2);
    }

    private void registerPrefix(String string, String string2) {
        this.singularPrefixes.add(string);
        this.pluralPrefixes.add(string2);
    }

    private static class PrefixEntry {
        public final String keyword;
        public final String prefixPlural;
        public final String prefixSingular;

        public PrefixEntry(String string, String string2, String string3) {
            this.keyword = string;
            this.prefixSingular = string2;
            this.prefixPlural = string3;
        }
    }
}

