/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.parser.ConversationContext;
import games.stendhal.common.parser.ConversationParser;
import games.stendhal.common.parser.Expression;
import games.stendhal.common.parser.ExpressionType;
import games.stendhal.common.parser.Sentence;
import games.stendhal.common.parser.SentenceImplementation;
import games.stendhal.common.parser.SimilarExprMatcher;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ExpressionMatcher {
    public static final String PM_SEPARATOR = "|";
    static final String PM_TYPE_MATCH = "TYPE";
    static final String PM_EXACT_MATCH = "EXACT";
    static final String PM_SIMILAR_MATCH = "SIMILAR";
    static final String PM_ICASE_MATCH = "ICASE";
    static final String PM_JOKER_MATCH = "JOKER";
    protected boolean typeMatching = false;
    protected boolean exactMatching = false;
    protected boolean similarMatching = false;
    protected boolean caseInsensitive = false;
    protected boolean jokerMatching = false;

    public void clear() {
        this.typeMatching = false;
        this.exactMatching = false;
        this.similarMatching = false;
        this.caseInsensitive = false;
        this.jokerMatching = false;
    }

    protected void setTypeMatching(boolean bl) {
        this.typeMatching = bl;
    }

    protected boolean getTypeMatching() {
        return this.typeMatching;
    }

    public void setExactMatching(boolean bl) {
        this.exactMatching = bl;
    }

    public boolean getExactMatching() {
        return this.exactMatching;
    }

    public void setSimilarMatching(boolean bl) {
        this.similarMatching = bl;
    }

    public boolean getSimilarMatching() {
        return this.similarMatching;
    }

    public void setCaseInsensitive(boolean bl) {
        this.caseInsensitive = bl;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean isJokerMatching() {
        return this.jokerMatching;
    }

    public void setJokerMatching(boolean bl) {
        this.jokerMatching = bl;
    }

    public boolean isAnyFlagSet() {
        return this.typeMatching || this.exactMatching || this.similarMatching || this.caseInsensitive || this.jokerMatching;
    }

    public boolean isEmpty() {
        return !this.isAnyFlagSet();
    }

    public String readMatchingFlags(String string) {
        this.clear();
        if (string.startsWith(PM_SEPARATOR)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, PM_SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(PM_TYPE_MATCH)) {
                    this.typeMatching = true;
                } else if (string2.equals(PM_EXACT_MATCH)) {
                    this.exactMatching = true;
                } else if (string2.equals(PM_SIMILAR_MATCH)) {
                    this.similarMatching = true;
                } else if (string2.equals(PM_ICASE_MATCH)) {
                    this.caseInsensitive = true;
                } else {
                    if (!string2.equals(PM_JOKER_MATCH)) break;
                    this.jokerMatching = true;
                }
                string = string.substring(string2.length() + 1);
            }
            if (this.isAnyFlagSet()) {
                string = string.substring(1);
            }
        }
        return string;
    }

    Sentence parseSentence(String string, ConversationContext conversationContext) {
        if (this.isEmpty()) {
            return ConversationParser.parse(string, conversationContext);
        }
        String string2 = string.trim();
        SentenceImplementation sentenceImplementation = new SentenceImplementation(conversationContext, string2);
        string2 = ConversationParser.detectSentenceType(string2, sentenceImplementation);
        if (this.typeMatching) {
            this.readTypeMatchExpressions(string2, sentenceImplementation);
        } else if (this.exactMatching) {
            this.readSimpleExpressions(string2, sentenceImplementation);
        } else if (this.similarMatching) {
            this.readSimpleExpressions(string2, sentenceImplementation);
        } else if (this.jokerMatching) {
            this.readJokerExpressions(string2, sentenceImplementation);
        } else if (this.caseInsensitive) {
            this.readSimpleExpressions(string2, sentenceImplementation);
        }
        return sentenceImplementation;
    }

    private void readTypeMatchExpressions(String string, Sentence sentence) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken();
            try {
                string2 = stringTokenizer.nextToken(" \t\n\r\f").substring(1);
            }
            catch (NoSuchElementException noSuchElementException) {
                string2 = "*";
            }
            Expression expression = new Expression(string3, string2);
            expression.setMatcher(this);
            sentence.expressions.add(expression);
        }
    }

    private void readSimpleExpressions(String string, Sentence sentence) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Expression expression = new Expression(string2);
            expression.setNormalized(string2);
            expression.setMatcher(this);
            sentence.expressions.add(expression);
        }
    }

    private void readJokerExpressions(String string, Sentence sentence) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Expression expression = new Expression(string2);
            if (ExpressionType.isTypeString(string2)) {
                expression.setType(new ExpressionType(string2));
                expression.setNormalized("*");
            } else {
                expression.setNormalized(string2);
            }
            expression.setMatcher(this);
            sentence.expressions.add(expression);
        }
    }

    public boolean match(Expression expression, Expression expression2) {
        if (this.typeMatching && !expression.getTypeString().equals(expression2.getTypeString())) {
            return false;
        }
        if (expression.getOriginal().equals(expression2.getOriginal())) {
            return true;
        }
        if (this.caseInsensitive && expression.getOriginal().equalsIgnoreCase(expression2.getOriginal())) {
            return true;
        }
        if (this.jokerMatching) {
            return expression.sentenceMatchExpression(expression2);
        }
        if (this.similarMatching && SimilarExprMatcher.isSimilar(expression.getOriginal(), expression2.getOriginal(), 0.1)) {
            return true;
        }
        if (!this.exactMatching) {
            if (expression2.getNormalized().equals("*")) {
                return true;
            }
            if (expression.getNormalized().equals(expression2.getNormalized())) {
                return true;
            }
            if (this.caseInsensitive && expression.getNormalized().equalsIgnoreCase(expression2.getNormalized())) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ExpressionMatcher) {
            ExpressionMatcher expressionMatcher = (ExpressionMatcher)object;
            if (this.typeMatching != expressionMatcher.typeMatching) {
                return false;
            }
            if (this.exactMatching != expressionMatcher.exactMatching) {
                return false;
            }
            if (this.similarMatching != expressionMatcher.similarMatching) {
                return false;
            }
            if (this.caseInsensitive != expressionMatcher.caseInsensitive) {
                return false;
            }
            return this.jokerMatching == expressionMatcher.jokerMatching;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        if (this.typeMatching) {
            n |= 1;
        }
        if (this.exactMatching) {
            n |= 2;
        }
        if (this.similarMatching) {
            n |= 4;
        }
        if (this.caseInsensitive) {
            n |= 8;
        }
        if (this.jokerMatching) {
            n |= 0x10;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.typeMatching) {
            stringBuilder.append(PM_SEPARATOR);
            stringBuilder.append(PM_TYPE_MATCH);
        }
        if (this.exactMatching) {
            stringBuilder.append(PM_SEPARATOR);
            stringBuilder.append(PM_EXACT_MATCH);
        }
        if (this.similarMatching) {
            stringBuilder.append(PM_SEPARATOR);
            stringBuilder.append(PM_SIMILAR_MATCH);
        }
        if (this.caseInsensitive) {
            stringBuilder.append(PM_SEPARATOR);
            stringBuilder.append(PM_ICASE_MATCH);
        }
        if (this.jokerMatching) {
            stringBuilder.append(PM_SEPARATOR);
            stringBuilder.append(PM_JOKER_MATCH);
        }
        return stringBuilder.toString();
    }
}

