/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.parser.Expression;
import java.util.Iterator;

public final class SentenceBuilder {
    private final StringBuilder builder = new StringBuilder();
    private boolean first = true;
    private char space = (char)32;

    public SentenceBuilder() {
        this.space = (char)32;
    }

    public SentenceBuilder(char c) {
        this.space = c;
    }

    public void append(String string) {
        if (this.first) {
            this.first = false;
        } else {
            this.builder.append(this.space);
        }
        this.builder.append(string);
    }

    public void append(char c) {
        this.builder.append(c);
    }

    public int appendUntilBreak(Iterator<Expression> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            this.append(expression.getNormalized());
            ++n;
            if (!expression.getBreakFlag()) continue;
            break;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.builder.toString().length() == 0;
    }

    public String toString() {
        return this.builder.toString();
    }
}

