/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.parser;

import games.stendhal.common.parser.ExpressionType;
import java.io.PrintWriter;

public final class WordEntry {
    private String normalized = "";
    private String plurSing;
    private ExpressionType type;
    private Integer value;
    private int id;

    public void print(PrintWriter printWriter, String string) {
        printWriter.printf("%s\t", string);
        if (this.type != null) {
            printWriter.print(this.type);
        }
        if (!this.normalized.equals(string)) {
            printWriter.printf("\t=%s", this.normalized);
        }
        if (this.value != null) {
            printWriter.printf("\t%d", this.value);
        }
        if (this.plurSing != null) {
            printWriter.printf("\t%s", this.plurSing);
        }
    }

    void setNormalized(String string) {
        this.normalized = string;
    }

    public String getNormalized() {
        return this.normalized;
    }

    void setType(ExpressionType expressionType) {
        this.type = expressionType;
    }

    public ExpressionType getType() {
        return this.type;
    }

    public String getTypeString() {
        if (this.type != null) {
            return this.type.getTypeString();
        }
        return "";
    }

    public String getNormalizedWithTypeString() {
        return this.normalized + "/" + this.getTypeString();
    }

    void setPlurSing(String string) {
        this.plurSing = string;
    }

    public String getPlurSing() {
        return this.plurSing;
    }

    public boolean isPlural() {
        return this.type != null && this.type.isPlural();
    }

    public boolean isVerb() {
        return this.type != null && this.type.isVerb();
    }

    public boolean isObject() {
        return this.type != null && this.type.isObject();
    }

    public boolean isSubject() {
        return this.type != null && this.type.isSubject();
    }

    public boolean isName() {
        return this.type != null && this.type.isName();
    }

    public boolean isNumeral() {
        return this.type != null && this.type.isNumeral();
    }

    public boolean isDynamic() {
        return this.type != null && this.type.isDynamic();
    }

    public boolean isPronoun() {
        return this.type != null && this.type.isPronoun();
    }

    public boolean isObsessional() {
        return this.type != null && this.type.isObsessional();
    }

    void setValue(Integer n) {
        this.value = n;
    }

    public Integer getValue() {
        return this.value;
    }

    void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.getNormalizedWithTypeString();
    }
}

