/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.common.tiled;

import games.stendhal.common.tiled.LayerDefinition;
import games.stendhal.common.tiled.TileSetDefinition;
import java.util.LinkedList;
import java.util.List;

public class StendhalMapStructure {
    int width;
    int height;
    List<TileSetDefinition> tilesets;
    List<LayerDefinition> layers;

    public StendhalMapStructure(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.tilesets = new LinkedList<TileSetDefinition>();
        this.layers = new LinkedList<LayerDefinition>();
    }

    public void addTileset(TileSetDefinition tileSetDefinition) {
        this.tilesets.add(tileSetDefinition);
    }

    public void addLayer(LayerDefinition layerDefinition) {
        layerDefinition.setMap(this);
        this.layers.add(layerDefinition);
    }

    public List<TileSetDefinition> getTilesets() {
        return this.tilesets;
    }

    public List<LayerDefinition> getLayers() {
        return this.layers;
    }

    public boolean hasLayer(String string) {
        return this.getLayer(string) != null;
    }

    public LayerDefinition getLayer(String string) {
        for (LayerDefinition layerDefinition : this.layers) {
            if (!string.equals(layerDefinition.getName())) continue;
            return layerDefinition;
        }
        return null;
    }

    public void build() {
        for (LayerDefinition layerDefinition : this.layers) {
            layerDefinition.build();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

