/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.update;

import games.stendhal.client.update.ClientGameConfiguration;
import games.stendhal.client.update.LoneOptionDialog;
import games.stendhal.client.update.SignatureVerifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;

public class Bootstrap {
    private String jarFolder;
    private Properties bootProp;
    private Properties bootPropOrg;

    public void saveBootProp() throws IOException {
        if (!this.bootProp.equals(this.bootPropOrg)) {
            String string = this.jarFolder + "jar.properties";
            try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
                this.bootProp.store(fileOutputStream, "PolanieOnLine Boot Configuration");
            }
        }
    }

    void init() {
        File file;
        String string = ClientGameConfiguration.get("GAME_NAME").toLowerCase();
        System.out.println("GAME: " + string);
        String string2 = System.getProperty("user.home") + File.separator + string + File.separator;
        String string3 = "AIX|Digital Unix|FreeBSD|HP UX|Irix|Linux|Mac OS X|Solaris";
        String string4 = System.getProperty("os.name");
        if (string4.matches(string3) && !(file = new File(string2 + "user.dat")).exists()) {
            string2 = System.getProperty("user.home") + File.separator + ".config" + File.separator + string + File.separator;
        }
        this.jarFolder = string2 + "jar" + File.separator;
        file = new File(this.jarFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        System.setProperty("log4j.ignoreTCL", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoader createClassloader(boolean bl, boolean bl2) throws Exception {
        String[] stringArray;
        Object object2;
        LinkedList<URL> linkedList = new LinkedList<URL>();
        if (bl) {
            object2 = this.jarFolder + "jar.properties";
            this.bootProp = new Properties();
            if (new File((String)object2).canRead()) {
                stringArray = new FileInputStream((String)object2);
                try {
                    this.bootProp.load((InputStream)stringArray);
                }
                finally {
                    stringArray.close();
                }
                this.bootPropOrg = (Properties)this.bootProp.clone();
                String object = this.bootProp.getProperty("load-1.16", "");
                StringTokenizer uRLClassLoader = new StringTokenizer(object, ",");
                while (uRLClassLoader.hasMoreTokens()) {
                    String string = uRLClassLoader.nextToken();
                    if (SignatureVerifier.get().checkSignature(this.jarFolder + string, this.bootProp.getProperty("file-signature." + string))) {
                        linkedList.add(new File(this.jarFolder + string).toURI().toURL());
                        continue;
                    }
                    if (!bl2) continue;
                    this.clearUpdateFiles();
                    URLClassLoader uRLClassLoader2 = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
                    return uRLClassLoader2;
                }
                System.out.println("our classpath: " + object);
            } else {
                System.out.println("no jar.properties");
            }
        }
        object2 = Bootstrap.class.getClassLoader();
        for (String string : stringArray = new String[]{"lib/log4j.jar", "lib/marauroa.jar", "lib/jorbis.jar", "lib/polanieonline.jar", "lib/polanieonline-data.jar", "lib/polanieonline-sound-data.jar", "lib/polanieonline-music-data.jar"}) {
            URL uRL = ((ClassLoader)object2).getResource(string);
            if (uRL == null) continue;
            linkedList.add(uRL);
        }
        System.out.println("Creating custom class loader for: " + linkedList);
        URL[] uRLArray = linkedList.toArray(new URL[linkedList.size()]);
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
        return uRLClassLoader;
    }

    private boolean isSigned() {
        try {
            Certificate[] certificateArray;
            Object[] objectArray = this.getClass().getSigners();
            if (objectArray == null || objectArray.length == 0) {
                System.err.println("Unsigned self built client.");
                return false;
            }
            if (!(objectArray instanceof Certificate[])) {
                System.err.println("Unknown signer class");
                return false;
            }
            for (Certificate certificate : certificateArray = (Certificate[])objectArray) {
                byte[] byArray = certificate.getPublicKey().getEncoded();
                String string = Bootstrap.toHexString(Bootstrap.hash(byArray));
                if (string.equals(ClientGameConfiguration.get("UPDATE_SIGNER_KEY"))) {
                    return true;
                }
                System.err.println("Skipping unknown signature: " + string + " from " + certificate);
                if (!(certificate instanceof X509Certificate)) continue;
                System.err.println("   " + ((X509Certificate)certificate).getSubjectX500Principal());
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private static final byte[] hash(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    private static final String toHexString(byte[] byArray) {
        String string = "0123456789ABCDEF";
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(string.charAt(by >>> 4 & 0xF));
            stringBuilder.append(string.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public void boot(String string, String[] stringArray) {
        try {
            System.setSecurityManager(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        boolean bl = true;
        if (this.isSigned()) {
            bl = false;
            System.err.println("Integrating old updates and looking for new ones");
            try {
                AccessController.doPrivileged(new PrivilegedBoot(string, stringArray));
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                int n = LoneOptionDialog.showConfirmDialog("Przepraszamy, ale wyst\u0105pi\u0142 b\u0142\u0105d z powodu niezgodno\u015bci podpisu kodu.\\r\\nUsun\u0105\u0107 pliki aktualizacji " + ClientGameConfiguration.get("GAME_NAME") + ", aby po ponownym uruchomieniu mog\u0142y by\u0107 pobrane ponownie?\r\nUwaga: Ten wyj\u0105tek mo\u017ce si\u0119 pojawi\u0107 w przypadku je\u015bli do podpisanych plik\u00f3w jar dodasz samodzielnie zbudowanego klienta.", ClientGameConfiguration.get("GAME_NAME"), 0, 3);
                if (n == 0) {
                    this.clearUpdateFiles();
                    System.exit(-1);
                }
                bl = true;
            }
        }
        if (bl) {
            System.err.println("Self build client, starting without update .jar-files");
            try {
                ClassLoader classLoader = this.createClassloader(false, false);
                Class<?> clazz = classLoader.loadClass(string);
                Method method = clazz.getMethod("main", stringArray.getClass());
                method.invoke(null, new Object[]{stringArray});
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                LoneOptionDialog.showMessageDialog("Co\u015b si\u0119 sta\u0142o podczas pr\u00f3by uruchomienia samodzielnie zbudowanego klienta: " + exception);
            }
        }
    }

    void unexpectedErrorHandling(String string, Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        throwable2.printStackTrace();
        if (throwable2 instanceof OutOfMemoryError) {
            LoneOptionDialog.showMessageDialog("Przepraszamy, ale wyst\u0105pi\u0142 brak pami\u0119ci. Prosz\u0119 uruchom ponownie " + ClientGameConfiguration.get("GAME_NAME") + ".");
        } else if (throwable2 instanceof LinkageError || throwable2 instanceof SecurityException || throwable2 instanceof ClassNotFoundException) {
            int n = LoneOptionDialog.showConfirmDialog(string + " Przepraszamy wyst\u0105pi\u0142 b\u0142\u0105d z powodu niew\u0142a\u015bciwego stanu aktualizacji.\r\nUsun\u0105\u0107 pliki aktualizacji " + ClientGameConfiguration.get("GAME_NAME") + " i pobra\u0107 je ponownie po ponownym uruchomieniu?", ClientGameConfiguration.get("GAME_NAME"), 0, 3);
            if (n == 0) {
                this.clearUpdateFiles();
            }
        } else {
            String string2 = this.stacktraceToString(throwable2);
            LoneOptionDialog.showMessageDialog(string + "Wyst\u0105pi\u0142 niespodziewany b\u0142\u0105d.\r\nPrzejd\u017a do formularza kontaktowego na https://s1.polanieonline.eu/kontakt-gmgags.html i napisz wiadomo\u015b\u0107 o b\u0142\u0119dzie:\r\n" + string2);
        }
        System.exit(1);
    }

    private void clearUpdateFiles() {
        this.bootProp.remove("load");
        this.bootProp.remove("load-1.16");
        try {
            this.saveBootProp();
        }
        catch (IOException iOException) {
            LoneOptionDialog.showMessageDialog("Nie mo\u017cna zapisa\u0107 jar.properties");
        }
    }

    String stacktraceToString(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(throwable.getMessage());
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            stringBuilder.append("\r\n");
            stringBuilder.append(stackTraceElement.toString());
        }
        return stringBuilder.toString();
    }

    private class PrivilegedBoot<T>
    implements PrivilegedAction<T> {
        private final String className;
        private final String[] args;

        public PrivilegedBoot(String string, String[] stringArray) {
            this.className = string;
            this.args = stringArray;
        }

        private void handleUpdate() {
            try {
                ClassLoader classLoader = Bootstrap.this.createClassloader(true, true);
                boolean bl = false;
                try {
                    classLoader.loadClass(this.className);
                    classLoader.loadClass("org.apache.log4j.Logger");
                    classLoader.loadClass("marauroa.common.Logger");
                    classLoader.loadClass("marauroa.client.ClientFramework");
                    if (classLoader.getResource(ClientGameConfiguration.get("GAME_ICON")) == null) {
                        throw new ClassNotFoundException(ClientGameConfiguration.get("GAME_ICON"));
                    }
                    if (classLoader.getResource("data/gui/offline.png") == null) {
                        throw new ClassNotFoundException(ClientGameConfiguration.get("data/gui/offline.png"));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = true;
                    System.out.println("Initial Download triggered by the following missing classes: " + classNotFoundException);
                }
                Class<?> clazz = classLoader.loadClass("games.stendhal.client.update.UpdateManager");
                Method method = clazz.getMethod("process", String.class, Properties.class, Boolean.class, ClassLoader.class);
                method.invoke(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), Bootstrap.this.jarFolder, Bootstrap.this.bootProp, bl, classLoader);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                Bootstrap.this.unexpectedErrorHandling("State: UpdateManager\r\n", exception);
            }
        }

        private void storeBootProp() {
            try {
                Bootstrap.this.saveBootProp();
            }
            catch (IOException iOException) {
                LoneOptionDialog.showMessageDialog("Przepraszamy, ale wyst\u0105pi\u0142 b\u0142\u0105d podczas pobierania aktualizacji. Nie mo\u017cna zapisa\u0107 bootProperties");
            }
        }

        private void loadProgram() {
            try {
                ClassLoader classLoader = Bootstrap.this.createClassloader(true, false);
                Class<?> clazz = classLoader.loadClass(this.className);
                Method method = clazz.getMethod("main", this.args.getClass());
                method.invoke(null, new Object[]{this.args});
            }
            catch (Throwable throwable) {
                Bootstrap.this.unexpectedErrorHandling("State: in game\r\n", throwable);
            }
        }

        @Override
        public T run() {
            Bootstrap.this.init();
            this.handleUpdate();
            this.storeBootProp();
            this.loadProgram();
            return null;
        }
    }
}

