/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.update;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ClientGameConfiguration {
    private static ClientGameConfiguration instance;
    private Properties gameConfig = this.getGameProperties();

    private ClientGameConfiguration() {
    }

    private Properties getGameProperties() {
        try {
            InputStream inputStream = ClientGameConfiguration.class.getResourceAsStream("game.properties");
            if (inputStream == null) {
                inputStream = ClientGameConfiguration.class.getResourceAsStream("game-default.properties");
            }
            if (inputStream == null) {
                throw new FileNotFoundException("Cannot read either game.properties or game-default.properties from classpath.");
            }
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
            return properties;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static synchronized void init() {
        if (instance == null) {
            instance = new ClientGameConfiguration();
        }
    }

    public static String get(String string) {
        ClientGameConfiguration.init();
        return ClientGameConfiguration.instance.gameConfig.getProperty(string);
    }
}

