/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.update;

import games.stendhal.client.update.ClientGameConfiguration;
import games.stendhal.client.update.UpdateManager;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

class SignatureVerifier {
    private static SignatureVerifier instance;
    private KeyStore ks = null;

    private SignatureVerifier() {
        String string = ClientGameConfiguration.get("UPDATE_CERTSTORE");
        InputStream inputStream = UpdateManager.class.getClassLoader().getResourceAsStream(string);
        if (inputStream != null) {
            this.ks = this.loadKeystore(inputStream);
        } else {
            System.err.println("Certstore " + string + " not found, configured as UPDATE_CERTSTORE in game.properties.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeystore(InputStream inputStream) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(inputStream, null);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return keyStore;
    }

    static synchronized SignatureVerifier get() {
        if (instance == null) {
            instance = new SignatureVerifier();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkSignature(String string, String string2) {
        if (this.ks == null || string2 == null) {
            System.out.println("No signature for " + string);
            return false;
        }
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(this.ks.getCertificate(ClientGameConfiguration.get("UPDATE_CERT_NAME")).getPublicKey());
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[1024];
            int n = 0;
            try {
                while (((InputStream)bufferedInputStream).available() != 0) {
                    n = ((InputStream)bufferedInputStream).read(byArray);
                    signature.update(byArray, 0, n);
                }
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
            boolean bl = signature.verify(SignatureVerifier.hexStringToByteArray(string2));
            System.out.println("Validated " + string + ": " + bl);
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    static byte[] hexStringToByteArray(String string) {
        String string2 = string;
        int n = string2.length();
        if (n % 2 == 1) {
            string2 = "0" + string2;
            ++n;
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string2.charAt(i), 16) << 4) + Character.digit(string2.charAt(i + 1), 16));
        }
        return byArray;
    }

    void registerTrustedCertificatesGlobally() {
        try {
            Object object;
            Object object2;
            String string = System.getProperty("java.home") + "/lib/security/cacerts";
            KeyStore keyStore = this.loadKeystore(new FileInputStream(string));
            Enumeration<String> enumeration = this.ks.aliases();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                object = this.ks.getCertificate((String)object2);
                keyStore.setCertificateEntry((String)object2, (Certificate)object);
            }
            object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object2).init(keyStore);
            object = SSLContext.getInstance("TLS");
            ((SSLContext)object).init(null, ((TrustManagerFactory)object2).getTrustManagers(), null);
            SSLContext.setDefault((SSLContext)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
        }
    }
}

