/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.update;

import games.stendhal.client.update.ClientGameConfiguration;
import games.stendhal.client.update.HttpClient;
import games.stendhal.client.update.SignatureVerifier;
import games.stendhal.client.update.UpdateGUIDialogs;
import games.stendhal.client.update.UpdateProgressBar;
import games.stendhal.client.update.VersionState;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

class UpdateManager {
    private String jarFolder;
    private Properties bootProp;
    private String serverFolder;
    private Properties updateProp;
    private ClassLoader classLoader;
    private UpdateProgressBar updateProgressBar;
    private String fromVersion;
    private String toVersion;

    public UpdateManager() {
        SignatureVerifier.get().registerTrustedCertificatesGlobally();
    }

    private void downloadUpdateProp(boolean bl) {
        HttpClient httpClient;
        String string;
        if (this.bootProp != null) {
            this.serverFolder = this.bootProp.getProperty("server.folder-1.16", ClientGameConfiguration.get("UPDATE_SERVER_FOLDER")) + "/";
            string = this.bootProp.getProperty("server.update-prop-1.16", this.serverFolder + "update-1.16.properties");
            httpClient = new HttpClient(string, bl);
            this.updateProp = httpClient.fetchProperties();
            if (this.updateProp != null && this.updateProp.containsKey("init.version")) {
                return;
            }
        }
        string = ClientGameConfiguration.get("UPDATE_SERVER_FOLDER") + "/update-1.16.properties";
        httpClient = new HttpClient(string, bl);
        this.updateProp = httpClient.fetchProperties();
        if (this.updateProp != null && this.updateProp.containsKey("init.version")) {
            return;
        }
        string = ClientGameConfiguration.get("UPDATE_SERVER_FOLDER_FALLBACK") + "/update-1.16.properties";
        httpClient = new HttpClient(string, bl);
        this.updateProp = httpClient.fetchProperties();
    }

    public void process(String string, Properties properties, Boolean bl, ClassLoader classLoader) {
        List<String> list;
        if (!Boolean.parseBoolean(ClientGameConfiguration.get("UPDATE_ENABLE_AUTO_UPDATE"))) {
            System.out.println("Automatic Update disabled");
            return;
        }
        this.jarFolder = string;
        this.bootProp = properties;
        this.classLoader = classLoader;
        this.downloadUpdateProp(bl);
        if (this.updateProp == null) {
            if (bl.booleanValue()) {
                UpdateGUIDialogs.messageBox("Potrzebne jest pobranie dodatkowych plik\u00f3w z\r\n" + this.serverFolder + "\r\n, ale serwer nie jest teraz dost\u0119pny. P\u00f3\u017aniej spr\u00f3buj ponownie.");
                System.exit(1);
            }
            return;
        }
        VersionState versionState = null;
        if (bl.booleanValue()) {
            versionState = VersionState.INITIAL_DOWNLOAD;
            this.fromVersion = null;
        } else {
            this.fromVersion = this.getVersion();
            list = this.updateProp.getProperty("version." + this.fromVersion);
            versionState = VersionState.getFromString((String)((Object)list));
        }
        if (this.fromVersion == null) {
            versionState = VersionState.INITIAL_DOWNLOAD;
        }
        System.out.println("Update state: " + (Object)((Object)versionState) + " initialDownload: " + bl + " fromVersion: " + this.fromVersion);
        switch (versionState) {
            case CURRENT: {
                System.out.println("Current Version");
                break;
            }
            case ERROR: {
                UpdateGUIDialogs.messageBox("Wyst\u0105pi\u0142 b\u0142\u0105d podczas aktualizacji");
                break;
            }
            case OUTDATED: {
                UpdateGUIDialogs.messageBox("Tw\u00f3j klient jest zbyt stary do aktualizacji. Pobierz najnowsz\u0105 wersj\u0119.");
                break;
            }
            case INITIAL_DOWNLOAD: {
                list = this.getFilesForFirstDownload();
                String string2 = this.updateProp.getProperty("init.version");
                if (string2 != null) {
                    list.addAll(this.getFilesToUpdate(string2));
                }
                ArrayList<String> arrayList = new ArrayList<String>(list);
                this.removeAlreadyExistingFiles(list);
                int n = this.getSizeOfFilesToUpdate(list);
                if (!this.downloadFiles(list, n)) break;
                this.updateClasspathConfig(arrayList);
                break;
            }
            case UPDATE_NEEDED: {
                String string3 = this.getVersion();
                list = this.getFilesToUpdate(string3);
                ArrayList<String> arrayList = new ArrayList<String>(list);
                this.removeAlreadyExistingFiles(list);
                int n = this.getSizeOfFilesToUpdate(list);
                if (n != 0 && !UpdateGUIDialogs.askForDownload(n, true) || !this.downloadFiles(list, n)) break;
                this.updateClasspathConfig(arrayList);
                break;
            }
            case UNKNOWN: {
                System.out.println("Unknown state of update");
                break;
            }
            default: {
                System.out.println("Internal Error on Update");
            }
        }
    }

    private String getVersion() {
        try {
            Class<?> clazz = this.classLoader.loadClass("games.stendhal.common.Version");
            return (String)clazz.getField("VERSION").get(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    private void removeAlreadyExistingFiles(List<String> list) {
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.trim().equals("")) {
                iterator.remove();
                continue;
            }
            try {
                long l;
                long l2 = Integer.parseInt(this.updateProp.getProperty("file-size." + string, ""));
                if (l2 != (l = new File(this.jarFolder + string).length())) continue;
                String string2 = this.updateProp.getProperty("file-signature." + string);
                if (!SignatureVerifier.get().checkSignature(this.jarFolder + string, string2)) continue;
                this.bootProp.put("file-signature." + string, string2);
                iterator.remove();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace(System.err);
            }
        }
    }

    private List<String> getFilesForFirstDownload() {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = this.updateProp.getProperty("init.file-list");
        linkedList.addAll(Arrays.asList(string.split(",")));
        while (linkedList.contains("")) {
            linkedList.remove("");
        }
        return linkedList;
    }

    private List<String> getFilesToUpdate(String string) {
        String string2;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = string;
        while ((string2 = this.updateProp.getProperty("update-file-list." + string3)) != null) {
            linkedList.addAll(Arrays.asList(string2.split(",")));
            string3 = this.updateProp.getProperty("version.destination." + string3);
        }
        this.toVersion = string3;
        while (linkedList.contains("")) {
            linkedList.remove("");
        }
        return linkedList;
    }

    private int getSizeOfFilesToUpdate(List<String> list) {
        int n = 0;
        for (String string : list) {
            try {
                n += Integer.parseInt(this.updateProp.getProperty("file-size." + string, ""));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
        }
        return n;
    }

    private boolean downloadFiles(List<String> list, int n) {
        this.updateProgressBar = new UpdateProgressBar(n, this.updateProp.getProperty("greetingUrl"), this.fromVersion, this.toVersion);
        this.updateProgressBar.setVisible(true);
        for (String string : list) {
            boolean bl = this.downloadFile(string);
            if (bl) continue;
            return false;
        }
        this.updateProgressBar.dispose();
        return true;
    }

    private boolean downloadFile(String string) {
        boolean bl = this.tryDownloadFromPreferredLocation(string);
        if (bl) {
            return true;
        }
        System.out.println("Pobieram " + string + " ...");
        HttpClient httpClient = new HttpClient(this.serverFolder + string, true);
        httpClient.setProgressListener(this.updateProgressBar);
        if (!httpClient.fetchFile(this.jarFolder + string)) {
            UpdateGUIDialogs.messageBox("Podczas pobierania aktualizacji wyst\u0105pi\u0142 b\u0142\u0105d w pliku " + string);
            return false;
        }
        try {
            File file = new File(this.jarFolder + string);
            int n = Integer.parseInt(this.updateProp.getProperty("file-size." + string, ""));
            String string2 = this.updateProp.getProperty("file-signature." + string);
            if (file.length() != (long)n || !SignatureVerifier.get().checkSignature(this.jarFolder + string, string2)) {
                UpdateGUIDialogs.messageBox("Podczas pobierania aktualizacji wyst\u0105pi\u0142 b\u0142\u0105d..\r\nSygnatura " + string + " r\u00f3\u017cni si\u0119.\r\nNasz ma " + file.length() + ", a powinien mie\u0107 " + n);
                this.updateProgressBar.dispose();
                return false;
            }
            this.bootProp.put("file-signature." + string, string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace(System.err);
            this.updateProgressBar.dispose();
            return false;
        }
        return true;
    }

    private boolean tryDownloadFromPreferredLocation(String string) {
        String string2 = this.updateProp.getProperty("location.preferred.folder");
        String string3 = this.updateProp.getProperty("location.preferred.suffix", "");
        System.out.println("checking for preferred location: preferredLocationFolder=" + string2 + " preferredLocationSuffix=" + string3);
        if (string2 == null) {
            return false;
        }
        System.out.println("Downloading " + string + " from preferred location...");
        HttpClient httpClient = new HttpClient(string2 + string + string3, false);
        httpClient.setProgressListener(this.updateProgressBar);
        if (!httpClient.fetchFile(this.jarFolder + string)) {
            System.out.println("fetch file failed, will retry from normal location");
            return false;
        }
        try {
            File file = new File(this.jarFolder + string);
            int n = Integer.parseInt(this.updateProp.getProperty("file-size." + string, ""));
            if (file.length() != (long)n) {
                System.out.println("wrong file size, will retry from normal location");
                return false;
            }
            if (!SignatureVerifier.get().checkSignature(this.jarFolder + string, this.updateProp.getProperty("file-signature." + string))) {
                System.out.println("signature verification failed");
                return false;
            }
            this.bootProp.put("file-signature." + string, this.updateProp.getProperty("file-signature." + string));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    private void updateClasspathConfig(List<String> list) {
        Collections.reverse(list);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string + ",");
        }
        if (!this.bootProp.getProperty("load-1.16", "").startsWith(stringBuilder.toString())) {
            stringBuilder.append(this.bootProp.getProperty("load-1.16", ""));
            this.bootProp.put("load-1.16", stringBuilder.toString());
        }
    }
}

