/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.gui.chattext.ChatTextController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import marauroa.common.game.RPAction;

public final class ChatOptions {
    private static final List<Option> options = new ArrayList<Option>();
    private static String attendingNPC;

    private ChatOptions() {
    }

    public static void update(String string, String string2, List<Option> list) {
        attendingNPC = string2 != null && !string2.isEmpty() ? string2 : string;
        options.clear();
        options.addAll(list);
        if (options.size() == 1 && "hello".equalsIgnoreCase(options.get(0).getTrigger())) {
            attendingNPC = null;
        }
    }

    public static List<Option> getOptions() {
        return Collections.unmodifiableList(options);
    }

    public static String getAttendingNPC() {
        return attendingNPC;
    }

    public static boolean isAttending(String string) {
        if (attendingNPC == null) {
            return false;
        }
        String string2 = attendingNPC.toLowerCase(Locale.ENGLISH);
        return string != null && string.toLowerCase(Locale.ENGLISH).equals(string2);
    }

    public static String findKeyword(Collection<String> collection) {
        for (Option option : options) {
            if (!ChatOptions.matches(option.getTrigger(), collection) && !ChatOptions.matches(option.getLabel(), collection)) continue;
            return option.getTrigger();
        }
        return null;
    }

    private static boolean matches(String string, Collection<String> collection) {
        for (String string2 : collection) {
            if (string == null || !string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static void sendKeyword(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        RPAction rPAction = new RPAction("chat");
        rPAction.put("type", "chat");
        rPAction.put("text", string);
        ClientSingletonRepository.getClientFramework().send(rPAction);
        ChatTextController.get().setChatLine(string);
    }

    public static class Option {
        private final String trigger;
        private final String label;

        public Option(String string, String string2) {
            this.trigger = string;
            this.label = string2;
        }

        public String getTrigger() {
            return this.trigger;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

