/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.gui.wt.core.SettingChangeListener;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.stendhal;
import games.stendhal.common.MathHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;
import org.apache.log4j.Logger;

public class GameLoop {
    private static final Logger logger = Logger.getLogger(GameLoop.class);
    private final Thread logicThread;
    private final Thread renderThread;
    private PersistentTask persistentTask;
    private Runnable renderTask;
    private final Queue<Runnable> temporaryTasks = new ConcurrentLinkedQueue<Runnable>();
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();
    private volatile boolean running;
    private volatile boolean renderRunning;
    private volatile long frameLengthNanos;
    private volatile long logicStepNanos;
    private static final long MAX_FRAME_DELTA_NANOS = 250000000L;
    private static final int MAX_CATCH_UP_STEPS = 5;
    private static final long SPIN_THRESHOLD_NANOS = 200000L;
    private static final long PARK_MARGIN_NANOS = 100000L;
    private static final long PARK_SKIP_THRESHOLD_NANOS = 5000000L;
    private static final long PARK_FRAME_LENGTH_THRESHOLD_NANOS = 8000000L;
    private static final Method ON_SPIN_WAIT_METHOD = GameLoop.resolveOnSpinWait();
    private volatile int currentFps;
    private final SettingChangeListener fpsLimitListener = new SettingChangeListener(){

        @Override
        public void changed(String string) {
            int n = MathHelper.parseIntDefault(string, stendhal.getFpsLimit());
            GameLoop.this.updateFrameLength(n);
        }
    };
    private long logicResidualNanos;
    private long logicSleepAdjustmentNanos;
    private long renderSleepAdjustmentNanos;

    private GameLoop() {
        int n = WtWindowManager.getInstance().getPropertyInt("ui.fps_limit", stendhal.getFpsLimit());
        this.updateFrameLength(n);
        WtWindowManager.getInstance().registerSettingChangeListener("ui.fps_limit", this.fpsLimitListener);
        this.logicThread = new Thread(new Runnable(){

            @Override
            public void run() {
                GameLoop.this.loop();
                for (Runnable runnable : GameLoop.this.cleanupTasks) {
                    runnable.run();
                }
            }
        }, "Game loop");
        this.renderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                GameLoop.this.renderLoop();
            }
        }, "Render loop");
    }

    private void updateFrameLength(int n) {
        int n2 = Math.max(1, n);
        stendhal.setFpsLimit(n2);
        this.logicStepNanos = this.frameLengthNanos = Math.max(1L, Math.round(1.0E9 / (double)n2));
        this.logicSleepAdjustmentNanos = 0L;
        this.renderSleepAdjustmentNanos = 0L;
        this.currentFps = n2;
    }

    public static GameLoop get() {
        return Holder.instance;
    }

    public static boolean isGameLoop() {
        return Thread.currentThread() == GameLoop.get().logicThread;
    }

    public void start() {
        this.running = true;
        this.renderRunning = true;
        this.logicThread.start();
        this.renderThread.start();
    }

    public void stop() {
        this.running = false;
        this.renderRunning = false;
    }

    public void runAllways(PersistentTask persistentTask) {
        this.persistentTask = persistentTask;
    }

    public void runRenderer(Runnable runnable) {
        this.renderTask = runnable;
    }

    public void runAtQuit(Runnable runnable) {
        this.cleanupTasks.add(runnable);
    }

    public void runOnce(Runnable runnable) {
        this.temporaryTasks.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        long l = 0L;
        long l2 = System.nanoTime();
        while (this.running) {
            long l3;
            long l4;
            long l5;
            long l6 = System.nanoTime();
            try {
                int n;
                l5 = l6;
                l4 = l5 - l2;
                if (l4 < 0L) {
                    l4 = 0L;
                }
                l4 = Math.min(l4, 250000000L);
                l2 = l5;
                l = Math.min(l + l4, 250000000L);
                l3 = this.logicStepNanos;
                for (n = 0; l >= l3 && n < 5; l -= l3, ++n) {
                    this.persistentTask.run(this.nanosToDelta(l3));
                }
                if (n == 0 && l >= 1000000L) {
                    long l7 = Math.min(l, l3);
                    this.persistentTask.run(this.nanosToDelta(l7));
                    l -= l7;
                }
                l = Math.max(0L, l);
                Runnable runnable = this.temporaryTasks.poll();
                while (runnable != null) {
                    runnable.run();
                    runnable = this.temporaryTasks.poll();
                }
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)runtimeException, (Throwable)runtimeException);
            }
            finally {
                l5 = this.frameLengthNanos;
                l4 = System.nanoTime() - l6;
                l3 = l5 - l4 + this.logicSleepAdjustmentNanos;
                this.logicSleepAdjustmentNanos = l3 > 0L ? this.sleepNanos(l3) : 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderLoop() {
        int n = 0;
        long l = System.nanoTime();
        while (this.renderRunning) {
            long l2 = System.nanoTime();
            try {
                Runnable runnable = this.renderTask;
                if (runnable != null) {
                    runnable.run();
                }
                ++n;
                if (l2 - l < 1000000000L) continue;
                this.currentFps = n;
                if (logger.isDebugEnabled()) {
                    this.reportClientInfo(n);
                }
                n = 0;
                l = l2;
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)runtimeException, (Throwable)runtimeException);
            }
            finally {
                long l3 = System.nanoTime() - l2;
                long l4 = this.frameLengthNanos - l3 + this.renderSleepAdjustmentNanos;
                this.renderSleepAdjustmentNanos = l4 > 0L ? this.sleepNanos(l4) : 0L;
            }
        }
        this.currentFps = 0;
    }

    private int nanosToDelta(long l) {
        long l2 = l + this.logicResidualNanos;
        long l3 = Math.max(1L, (l2 + 500000L) / 1000000L);
        this.logicResidualNanos = l2 - l3 * 1000000L;
        if (l3 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    private long sleepNanos(long l) {
        long l2;
        boolean bl;
        long l3 = System.nanoTime();
        long l4 = l3 + l;
        long l5 = l;
        boolean bl2 = bl = l5 >= 5000000L && this.frameLengthNanos >= 8000000L;
        if (bl && l5 > 300000L && (l2 = l5 - 200000L) > 0L) {
            LockSupport.parkNanos(l2);
        }
        while ((l5 = l4 - System.nanoTime()) > 0L) {
            if (l5 <= 1000L) continue;
            GameLoop.spinWait();
        }
        l2 = System.nanoTime() - l3;
        return l - l2;
    }

    private static Method resolveOnSpinWait() {
        try {
            return Thread.class.getMethod("onSpinWait", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static void spinWait() {
        if (ON_SPIN_WAIT_METHOD != null) {
            try {
                ON_SPIN_WAIT_METHOD.invoke(null, new Object[0]);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Thread.yield();
    }

    private void reportClientInfo(int n) {
        logger.debug((Object)("FPS: " + n));
        long l = Runtime.getRuntime().freeMemory() / 1024L;
        long l2 = Runtime.getRuntime().totalMemory() / 1024L;
        logger.debug((Object)("Total/Used memory: " + l2 + "/" + (l2 - l)));
    }

    public int getCurrentFps() {
        return this.currentFps;
    }

    public static interface PersistentTask {
        public void run(int var1);
    }

    private static class Holder {
        static GameLoop instance = new GameLoop();

        private Holder() {
        }
    }
}

