/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.EntityViewManager;
import games.stendhal.client.GameLoop;
import games.stendhal.client.GameObjects;
import games.stendhal.client.GameScreenSpriteHelper;
import games.stendhal.client.IGameScreen;
import games.stendhal.client.StaticGameLayers;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.Zone;
import games.stendhal.client.entity.Corpse;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Item;
import games.stendhal.client.gui.DropTarget;
import games.stendhal.client.gui.EffectLayer;
import games.stendhal.client.gui.GroundContainer;
import games.stendhal.client.gui.j2d.AchievementBoxFactory;
import games.stendhal.client.gui.j2d.RemovableSprite;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.spellcasting.SpellCastingGroundContainerMouseState;
import games.stendhal.client.gui.wt.core.SettingChangeListener;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.stendhal;
import games.stendhal.common.MathHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.image.VolatileImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public final class GameScreen
extends JComponent
implements IGameScreen,
DropTarget,
GameObjects.GameObjectListener,
StendhalClient.ZoneChangeListener {
    private static final long serialVersionUID = -4070406295913030925L;
    private static final Logger logger = Logger.getLogger(GameScreen.class);
    private static final Map<Integer, Integer> keyEventMapping = new HashMap<Integer, Integer>();
    private static final int PAN_SCALE = 8;
    private static final double BASE_FRAME_MILLIS = 16.666666666666668;
    private static final double MAX_STABLE_ACCUM_MS = 200.0;
    private static final double STABLE_SAMPLE_INTERVAL_MS = 45.0;
    private static final int PAN_INERTIA = 15;
    private static final int OFFLINE_MARGIN = 10;
    private static final Sprite offlineIcon;
    private final StaticGameLayers gameLayers;
    private static final Collection<EffectLayer> globalEffects;
    private final EntityViewManager viewManager = new EntityViewManager();
    private final GroundContainer ground;
    private final List<RemovableSprite> staticSprites;
    private boolean offline;
    private volatile boolean showFpsCounter;
    private int blinkOffline;
    private static final double POSITION_EPSILON = 0.001;
    private double x;
    private double y;
    private int sw;
    private int sh;
    private int dvx;
    private int dvy;
    private double pendingDx;
    private double pendingDy;
    private long lastFrameNanos;
    private double stableAccumulator;
    private double speed;
    private boolean useScaling = true;
    private boolean useTripleBuffer;
    private VolatileImage buffer;
    private AchievementBoxFactory achievementBoxFactory;
    private static GameScreen screen;

    public static GameScreen get(StendhalClient stendhalClient) {
        if (screen == null) {
            screen = new GameScreen(stendhalClient);
        }
        return screen;
    }

    public static GameScreen get() {
        return screen;
    }

    private GameScreen(StendhalClient stendhalClient) {
        this.setSize(stendhal.getDisplaySize());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GameScreen.this.onResized();
            }
        });
        this.gameLayers = stendhalClient.getStaticGameLayers();
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        this.x = 0.0;
        this.y = 0.0;
        GameScreenSpriteHelper.setScreenViewX(-this.sw / 2);
        GameScreenSpriteHelper.setScreenViewY(-this.sh / 2);
        this.dvx = 0;
        this.dvy = 0;
        this.pendingDx = 0.0;
        this.pendingDy = 0.0;
        this.speed = 0.0;
        GameScreenSpriteHelper.setTexts(Collections.synchronizedList(new LinkedList()));
        this.staticSprites = Collections.synchronizedList(new LinkedList());
        GameScreenSpriteHelper.setEmojis(Collections.synchronizedList(new LinkedList()));
        this.ground = new GroundContainer(stendhalClient, this, this);
        this.addMouseListener(this.ground);
        this.addMouseWheelListener(this.ground);
        this.addMouseMotionListener(this.ground);
        this.setIgnoreRepaint(true);
        stendhalClient.getGameObjects().addGameObjectListener(this);
        this.showFpsCounter = WtWindowManager.getInstance().getPropertyBoolean("ui.fps_counter", false);
        WtWindowManager.getInstance().registerSettingChangeListener("ui.fps_counter", new SettingChangeListener(){

            @Override
            public void changed(String string) {
                GameScreen.this.showFpsCounter = Boolean.parseBoolean(string);
            }
        });
    }

    private void onResized() {
        Dimension dimension = stendhal.getDisplaySize();
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        if (this.useScaling) {
            double d = (double)this.sw / dimension.getWidth();
            double d2 = (double)this.sh / dimension.getHeight();
            double d3 = Math.max(d, d2);
            GameScreenSpriteHelper.setScale(d3);
            if (Math.abs(d3 - 1.0) > 1.0E-4) {
                this.useTripleBuffer = true;
            } else {
                this.useTripleBuffer = false;
                this.buffer = null;
            }
        } else {
            this.sw = Math.min(this.sw, dimension.width);
            this.sh = Math.min(this.sh, dimension.height);
            this.useTripleBuffer = false;
            this.buffer = null;
        }
        this.calculateView(this.x, this.y);
        this.center();
    }

    public void setUseScaling(boolean bl) {
        this.useScaling = bl;
        if (!bl) {
            GameScreenSpriteHelper.setScale(1.0);
            this.useTripleBuffer = false;
            this.buffer = null;
        } else {
            this.onResized();
        }
    }

    public boolean isScaled() {
        return this.useScaling;
    }

    public static void setDefaultScreen(GameScreen gameScreen) {
        screen = gameScreen;
    }

    private int getViewWidth() {
        return (int)Math.ceil((double)this.sw / (32.0 * GameScreenSpriteHelper.getScale()));
    }

    private int getViewHeight() {
        return (int)Math.ceil((double)this.sh / (32.0 * GameScreenSpriteHelper.getScale()));
    }

    @Override
    public void nextFrame() {
        double d;
        long l = System.nanoTime();
        if (this.lastFrameNanos == 0L) {
            d = 16.666666666666668;
        } else {
            d = (double)(l - this.lastFrameNanos) / 1000000.0;
            if (d <= 0.0) {
                d = 16.666666666666668;
            }
        }
        this.lastFrameNanos = l;
        this.adjustView(d);
    }

    private AchievementBoxFactory getAchievementFactory() {
        if (this.achievementBoxFactory == null) {
            this.achievementBoxFactory = new AchievementBoxFactory();
        }
        return this.achievementBoxFactory;
    }

    @Override
    public void addEntity(IEntity iEntity) {
        EntityView<IEntity> entityView = this.viewManager.addEntity(iEntity);
        if (entityView != null) {
            if (entityView instanceof Entity2DView) {
                Entity2DView entity2DView = (Entity2DView)entityView;
                entity2DView.setInspector(this.ground);
            }
            if (iEntity.isUser()) {
                SwingUtilities.invokeLater(this::center);
            }
        }
    }

    public void addEffect(EffectLayer effectLayer) {
        SwingUtilities.invokeLater(() -> globalEffects.add(effectLayer));
    }

    @Override
    public void removeEntity(IEntity iEntity) {
        this.viewManager.removeEntity(iEntity);
    }

    private void adjustView(double d) {
        if (this.dvx == 0 && this.dvy == 0) {
            this.pendingDx = 0.0;
            this.pendingDy = 0.0;
            this.speed = 0.0;
            this.stableAccumulator = Math.min(this.stableAccumulator + d, 200.0);
            return;
        }
        int n = GameScreenSpriteHelper.convertWorldXToScaledScreen(this.x) - GameScreenSpriteHelper.getScreenViewX() + 16;
        int n2 = GameScreenSpriteHelper.convertWorldYToScaledScreen(this.y) - GameScreenSpriteHelper.getScreenViewY() + 16;
        if (n < 0 || n >= this.sw || n2 < -32 || n2 > this.sh) {
            this.center();
        } else {
            boolean bl;
            double d2 = this.computeDynamicDeadZone(d);
            boolean bl2 = (double)Math.abs(this.dvx) <= d2;
            boolean bl3 = bl = (double)Math.abs(this.dvy) <= d2;
            if (bl2 && bl && Math.abs(this.pendingDx) < 0.5 && Math.abs(this.pendingDy) < 0.5) {
                this.stableAccumulator = Math.min(this.stableAccumulator + d, 200.0);
                if (this.stableAccumulator >= 45.0) {
                    this.center();
                    this.stableAccumulator = 0.0;
                }
                this.speed = 0.0;
                return;
            }
            this.stableAccumulator = 0.0;
            this.calculatePanningSpeed(d);
            if (this.speed > 0.0) {
                int n3 = (Math.abs(this.dvx) + Math.abs(this.dvy)) * 8;
                double d3 = this.speed * (double)this.dvx / (double)n3;
                double d4 = this.speed * (double)this.dvy / (double)n3;
                double d5 = this.applyDeadZoneScale(this.dvx, d2);
                double d6 = this.applyDeadZoneScale(this.dvy, d2);
                this.pendingDx += d3 * d5;
                this.pendingDy += d4 * d6;
                int n4 = this.limitMoveDelta(this.extractMove(this.pendingDx, this.dvx), this.dvx);
                int n5 = this.limitMoveDelta(this.extractMove(this.pendingDy, this.dvy), this.dvy);
                if (n4 != 0) {
                    GameScreenSpriteHelper.setScreenViewX(GameScreenSpriteHelper.getScreenViewX() + n4);
                    this.dvx -= n4;
                    this.pendingDx -= (double)n4;
                    this.pendingDx = this.clampDouble(this.pendingDx, -1.0, 1.0);
                } else if (bl2) {
                    this.dvx = 0;
                    this.pendingDx = 0.0;
                } else {
                    this.pendingDx = this.clampDouble(this.pendingDx, -1.0, 1.0);
                }
                if (n5 != 0) {
                    GameScreenSpriteHelper.setScreenViewY(GameScreenSpriteHelper.getScreenViewY() + n5);
                    this.dvy -= n5;
                    this.pendingDy -= (double)n5;
                    this.pendingDy = this.clampDouble(this.pendingDy, -1.0, 1.0);
                } else if (bl) {
                    this.dvy = 0;
                    this.pendingDy = 0.0;
                } else {
                    this.pendingDy = this.clampDouble(this.pendingDy, -1.0, 1.0);
                }
            }
        }
    }

    private int limitMoveDelta(int n, int n2) {
        if (n2 < 0) {
            n = MathHelper.clamp(n, n2, -1);
        } else if (n2 > 0) {
            n = MathHelper.clamp(n, 1, n2);
        }
        return n;
    }

    private int extractMove(double d, int n) {
        int n2 = 0;
        if (d > 1.0) {
            n2 = (int)Math.floor(d);
        } else if (d < -1.0) {
            n2 = (int)Math.ceil(d);
        } else if (n != 0 && d != 0.0 && Math.abs(n) <= 1) {
            n2 = n > 0 ? 1 : -1;
        }
        return n2;
    }

    private void calculatePanningSpeed(double d) {
        int n = this.dvx / 15;
        int n2 = this.dvy / 15;
        double d2 = (n * n + n2 * n2) * 8;
        double d3 = Math.max(d / 16.666666666666668, 0.0);
        double d4 = 1.0 - Math.pow(0.6666666666666667, Math.min(d3, 60.0));
        this.speed += (d2 - this.speed) * d4;
        if (this.dvx != 0 || this.dvy != 0) {
            this.speed = Math.max(this.speed, 1.0);
        } else if (Math.abs(this.speed) < 1.0E-4) {
            this.speed = 0.0;
        }
    }

    private double computeDynamicDeadZone(double d) {
        double d2 = Math.max(1.0, (double)GameLoop.get().getCurrentFps());
        double d3 = this.clampDouble(60.0 / d2, 0.5, 1.5);
        double d4 = this.clampDouble(d / 16.666666666666668, 0.5, 1.5);
        double d5 = this.clampDouble(this.speed / 12.0, 0.0, 1.5);
        double d6 = 0.75 + (d3 - 0.5) * 1.5 + (d4 - 0.5) * 0.5 + d5 * 1.25;
        return this.clampDouble(d6 * 2.0, 1.0, 6.0);
    }

    private double applyDeadZoneScale(int n, double d) {
        int n2 = Math.abs(n);
        if (n2 == 0) {
            return 0.0;
        }
        if ((double)n2 <= d) {
            return 0.0;
        }
        double d2 = ((double)n2 - d) / (double)n2;
        return this.clampDouble(d2, 0.0, 1.0);
    }

    private double clampDouble(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d3, d));
    }

    private void calculateView(double d, double d2) {
        double d3 = GameScreenSpriteHelper.getScale();
        double d4 = d * 32.0 + 16.0;
        double d5 = d2 * 32.0 + 16.0;
        int n = (int)(d4 - (double)this.sw / 2.0 / d3);
        int n2 = (int)(d5 - (double)this.sh / 2.0 / d3);
        int n3 = (int)((double)(GameScreenSpriteHelper.getWorldWidth() * 32) - (double)this.sw / d3);
        n = n3 < 0 ? n3 / 2 : MathHelper.clamp(n, 0, n3);
        int n4 = (int)((double)(GameScreenSpriteHelper.getWorldHeight() * 32) - (double)this.sh / d3);
        n2 = n4 < 0 ? n4 / 2 : MathHelper.clamp(n2, 0, n4);
        this.dvx = n - GameScreenSpriteHelper.getScreenViewX();
        this.dvy = n2 - GameScreenSpriteHelper.getScreenViewY();
        this.stableAccumulator = 0.0;
        if (this.pendingDx > 0.0 && this.dvx <= 0 || this.pendingDx < 0.0 && this.dvx >= 0) {
            this.pendingDx = 0.0;
        }
        if (this.pendingDy > 0.0 && this.dvy <= 0 || this.pendingDy < 0.0 && this.dvy >= 0) {
            this.pendingDy = 0.0;
        }
    }

    @Override
    public void center() {
        GameScreenSpriteHelper.setScreenViewX(GameScreenSpriteHelper.getScreenViewX() + this.dvx);
        GameScreenSpriteHelper.setScreenViewY(GameScreenSpriteHelper.getScreenViewY() + this.dvy);
        this.dvx = 0;
        this.dvy = 0;
        this.speed = 0.0;
        this.pendingDx = 0.0;
        this.pendingDy = 0.0;
        this.stableAccumulator = 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (StendhalClient.get().tryAcquireDrawingSemaphore()) {
            try {
                super.paintImmediately(n, n2, n3, n4);
            }
            finally {
                StendhalClient.get().releaseDrawingSemaphore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.BLACK);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = GameScreenSpriteHelper.getScreenViewX();
        int n2 = GameScreenSpriteHelper.getScreenViewY();
        GameScreenSpriteHelper.beginFrame(n, n2);
        try {
            block16: {
                if (StendhalClient.get().isInTransfer()) {
                    return;
                }
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                try {
                    if (graphics2D2.getClipBounds() == null) {
                        graphics2D2.setClip(0, 0, this.getWidth(), this.getHeight());
                    }
                    Rectangle rectangle = graphics2D2.getClipBounds();
                    boolean bl = rectangle.width == this.sw && rectangle.height == this.sh;
                    int n3 = -n;
                    int n4 = -n2;
                    if (this.useTripleBuffer) {
                        double d = GameScreenSpriteHelper.getScale();
                        graphics2D2.scale(d, d);
                        graphics2D2.translate(n3, n4);
                        graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        int n5 = stendhal.getDisplaySize().width;
                        int n6 = stendhal.getDisplaySize().height;
                        do {
                            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
                            if (this.buffer == null || this.buffer.validate(graphicsConfiguration) == 2) {
                                this.buffer = this.createVolatileImage(n5, n6);
                            }
                            Graphics2D graphics2D3 = this.buffer.createGraphics();
                            try {
                                graphics2D3.setColor(Color.BLACK);
                                graphics2D3.fillRect(0, 0, n5, n6);
                                graphics2D3.setClip(0, 0, n5, n6);
                                this.renderScene(graphics2D3, n3, n4, bl);
                            }
                            finally {
                                graphics2D3.dispose();
                            }
                            graphics2D2.drawImage(this.buffer, -n3, -n4, null);
                        } while (this.buffer.contentsLost());
                        break block16;
                    }
                    this.renderScene(graphics2D2, n3, n4, bl);
                }
                finally {
                    graphics2D2.dispose();
                }
            }
            this.drawText(graphics2D, n, n2);
            this.drawEmojis(graphics2D, n, n2);
            this.drawFpsCounter(graphics2D);
            this.paintOffLineIfNeeded(graphics2D);
            Toolkit.getDefaultToolkit().sync();
        }
        finally {
            GameScreenSpriteHelper.endFrame();
        }
    }

    private void renderScene(Graphics2D graphics2D, int n, int n2, boolean bl) {
        graphics2D.translate(n, n2);
        int n3 = Math.max(0, (int)this.getViewX());
        int n4 = Math.max(0, (int)this.getViewY());
        Rectangle rectangle = graphics2D.getClipBounds();
        n3 = Math.max(n3, rectangle.x / 32);
        n4 = Math.max(n4, rectangle.y / 32);
        int n5 = this.getViewWidth();
        int n6 = this.getViewHeight();
        n5 = Math.min(n5, rectangle.width / 32) + 2;
        n6 = Math.min(n6, rectangle.height / 32) + 2;
        this.viewManager.prepareViews(rectangle, bl);
        String string = this.gameLayers.getAreaName();
        this.gameLayers.drawLayers(graphics2D, string, "floor_bundle", n3, n4, n5, n6, "blend_ground", "0_floor", "1_terrain", "2_object");
        this.viewManager.draw(graphics2D);
        this.gameLayers.drawLayers(graphics2D, string, "roof_bundle", n3, n4, n5, n6, "blend_roof", "3_roof", "4_roof_add");
        this.gameLayers.drawWeather(graphics2D, n3, n4, n5, n6);
        this.viewManager.drawTop(graphics2D);
        Iterator<EffectLayer> iterator = globalEffects.iterator();
        while (iterator.hasNext()) {
            EffectLayer effectLayer = iterator.next();
            if (!effectLayer.isExpired()) {
                effectLayer.draw(graphics2D, n3, n4, n5, n6);
                continue;
            }
            iterator.remove();
        }
    }

    private void paintOffLineIfNeeded(Graphics graphics) {
        if (this.offline) {
            if (this.blinkOffline > 0) {
                offlineIcon.draw(graphics, this.getWidth() - offlineIcon.getWidth() - 10, this.getHeight() - offlineIcon.getHeight() - 10);
            }
            this.blinkOffline = this.blinkOffline < -10 ? 20 : --this.blinkOffline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawText(Graphics2D graphics2D, int n, int n2) {
        RemovableSprite removableSprite;
        Iterator<RemovableSprite> iterator;
        List<RemovableSprite> list;
        graphics2D.translate(-n, -n2);
        List<RemovableSprite> list2 = list = GameScreenSpriteHelper.getTexts();
        synchronized (list2) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                removableSprite = iterator.next();
                if (!removableSprite.shouldBeRemoved()) {
                    removableSprite.draw(graphics2D);
                    continue;
                }
                iterator.remove();
            }
        }
        graphics2D.translate(n, n2);
        list2 = this.staticSprites;
        synchronized (list2) {
            iterator = this.staticSprites.iterator();
            while (iterator.hasNext()) {
                removableSprite = iterator.next();
                if (!removableSprite.shouldBeRemoved()) {
                    removableSprite.draw(graphics2D);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawEmojis(Graphics2D graphics2D, int n, int n2) {
        List<RemovableSprite> list;
        List<RemovableSprite> list2 = list = GameScreenSpriteHelper.getEmojis();
        synchronized (list2) {
            Iterator<RemovableSprite> iterator = list.iterator();
            while (iterator.hasNext()) {
                RemovableSprite removableSprite = iterator.next();
                if (!removableSprite.shouldBeRemoved()) {
                    removableSprite.drawEmoji(graphics2D, n, n2);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private void drawFpsCounter(Graphics2D graphics2D) {
        if (!this.showFpsCounter) {
            return;
        }
        int n = GameLoop.get().getCurrentFps();
        String string = n + " FPS";
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getHeight();
        int n4 = 4;
        int n5 = this.getWidth() - n2 - n4 * 2;
        int n6 = n4;
        graphics2D.setColor(new Color(0, 0, 0, 170));
        graphics2D.fillRect(n5 - n4, n6 - n4, n2 + n4 * 2, n3 + n4);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(string, n5, n6 + fontMetrics.getAscent());
    }

    private double getViewX() {
        return (double)GameScreenSpriteHelper.getScreenViewX() / 32.0;
    }

    private double getViewY() {
        return (double)GameScreenSpriteHelper.getScreenViewY() / 32.0;
    }

    private void setMaxWorldSize(double d, double d2) {
        GameScreenSpriteHelper.setWorldWidth((int)d);
        GameScreenSpriteHelper.setWorldHeight((int)d2);
        this.calculateView(this.x, this.y);
        this.center();
    }

    @Override
    public void setOffline(boolean bl) {
        this.offline = bl;
    }

    public void addTextBox(Sprite sprite, double d, double d2, int n) {
        int n2 = GameScreenSpriteHelper.convertWorldXToScaledScreen(d);
        int n3 = GameScreenSpriteHelper.convertWorldYToScaledScreen(d2);
        n3 -= sprite.getHeight();
        n2 = GameScreenSpriteHelper.keepSpriteOnMapX(sprite, n2);
        n3 = GameScreenSpriteHelper.keepSpriteOnMapY(sprite, n3);
        n3 = GameScreenSpriteHelper.findFreeTextBoxPosition(sprite, n2, n3);
        GameScreenSpriteHelper.addText(new RemovableSprite(sprite, n2, n3, Math.max(5000L, (long)n * 5000L / 50L)));
    }

    public void addTextBox(Sprite sprite, Entity entity, int n) {
        GameScreenSpriteHelper.addText(new RemovableSprite(sprite, entity, Math.max(5000L, (long)n * 5000L / 50L)));
    }

    @Override
    public void removeText(RemovableSprite removableSprite) {
        GameScreenSpriteHelper.removeText(removableSprite);
        this.staticSprites.remove(removableSprite);
    }

    public void addEmoji(Sprite sprite, Entity entity) {
        GameScreenSpriteHelper.addEmoji(new RemovableSprite(sprite, entity, 5000L));
    }

    public void removeEmoji(RemovableSprite removableSprite) {
        GameScreenSpriteHelper.removeEmoji(removableSprite);
    }

    private void removeAllObjects() {
        logger.debug((Object)"CLEANING screen object list");
        GameScreenSpriteHelper.clearTexts();
        GameScreenSpriteHelper.clearEmojis();
    }

    @Override
    public void clearTexts() {
        GameScreenSpriteHelper.clearTexts();
        this.staticSprites.clear();
        this.clearEmojis();
    }

    public void clearEmojis() {
        GameScreenSpriteHelper.clearEmojis();
    }

    @Override
    public EntityView<?> getEntityViewAt(double d, double d2) {
        int n = GameScreenSpriteHelper.convertWorldToPixelUnits(d);
        int n2 = GameScreenSpriteHelper.convertWorldToPixelUnits(d2);
        return this.viewManager.getEntityViewAt(d, d2, n, n2);
    }

    @Override
    public EntityView<?> getMovableEntityViewAt(double d, double d2) {
        int n = GameScreenSpriteHelper.convertWorldToPixelUnits(d);
        int n2 = GameScreenSpriteHelper.convertWorldToPixelUnits(d2);
        return this.viewManager.getMovableEntityViewAt(d, d2, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemovableSprite getTextAt(int n, int n2) {
        Object object;
        List<RemovableSprite> list = this.staticSprites;
        synchronized (list) {
            ListIterator<RemovableSprite> listIterator = this.staticSprites.listIterator(this.staticSprites.size());
            while (listIterator.hasPrevious()) {
                object = listIterator.previous();
                if (!((RemovableSprite)object).getArea().contains(n, n2)) continue;
                return object;
            }
        }
        int n3 = n + GameScreenSpriteHelper.getScreenViewX();
        int n4 = n2 + GameScreenSpriteHelper.getScreenViewY();
        Object object2 = object = GameScreenSpriteHelper.getTexts();
        synchronized (object2) {
            ListIterator listIterator = object.listIterator(object.size());
            while (listIterator.hasPrevious()) {
                RemovableSprite removableSprite = (RemovableSprite)listIterator.previous();
                if (!removableSprite.getArea().contains(n3, n4)) continue;
                return removableSprite;
            }
        }
        return null;
    }

    @Override
    public Point2D convertScreenViewToWorld(Point point) {
        return this.convertScreenViewToWorld(point.x, point.y);
    }

    @Override
    public Point2D convertScreenViewToWorld(int n, int n2) {
        double d = GameScreenSpriteHelper.getScale();
        return new Point2D.Double(((double)n / d + (double)GameScreenSpriteHelper.getScreenViewX()) / 32.0, ((double)n2 / d + (double)GameScreenSpriteHelper.getScreenViewY()) / 32.0);
    }

    @Override
    public void positionChanged(double d, double d2) {
        if (Math.abs(d - this.x) > 0.001 || Math.abs(d2 - this.y) > 0.001) {
            this.x = d;
            this.y = d2;
            this.calculateView(d, d2);
        }
    }

    @Override
    public void dropEntity(IEntity iEntity, int n, Point point) {
        this.ground.dropEntity(iEntity, n, point);
    }

    public void addAchievementBox(String string, String string2, String string3) {
        Sprite sprite = this.getAchievementFactory().createAchievementBox(string, string2, string3);
        this.addStaticSprite(sprite, 10000L, 0);
    }

    public void addStaticText(Sprite sprite, int n, int n2) {
        this.addStaticSprite(sprite, Math.max(5000L, (long)n * 5000L / 50L), n2);
    }

    private void addStaticSprite(Sprite sprite, long l, int n) {
        int n2 = (this.getWidth() - sprite.getWidth()) / 2;
        int n3 = this.getHeight() - sprite.getHeight();
        RemovableSprite removableSprite = new RemovableSprite(sprite, n2, n3, l);
        removableSprite.setPriority(n);
        this.staticSprites.add(removableSprite);
        Collections.sort(this.staticSprites);
    }

    @Override
    public void onZoneUpdate(Zone zone) {
        this.viewManager.resetViews();
    }

    @Override
    public void onZoneChange(Zone zone) {
        this.removeAllObjects();
        SwingUtilities.invokeLater(globalEffects::clear);
    }

    @Override
    public void onZoneChangeCompleted(Zone zone) {
        SwingUtilities.invokeLater(() -> this.setMaxWorldSize(zone.getWidth(), zone.getHeight()));
    }

    public void switchToSpellCasting(KeyEvent keyEvent) {
        RPObject rPObject = this.findSpell(keyEvent);
        if (rPObject != null) {
            this.switchToSpellCastingState(rPObject);
        }
    }

    public void switchToSpellCastingState(RPObject rPObject) {
        SpellCastingGroundContainerMouseState spellCastingGroundContainerMouseState = new SpellCastingGroundContainerMouseState(this.ground);
        this.ground.setNewMouseHandlerState(spellCastingGroundContainerMouseState);
        spellCastingGroundContainerMouseState.setSpell(rPObject);
    }

    private RPObject findSpell(KeyEvent keyEvent) {
        RPObject rPObject = StendhalClient.get().getPlayer();
        Integer n = keyEventMapping.get(keyEvent.getKeyCode());
        RPSlot rPSlot = rPObject.getSlot("spells");
        Integer n2 = 1;
        for (RPObject rPObject2 : rPSlot) {
            if (n2.equals(n)) {
                return rPObject2;
            }
            n2 = n2 + 1;
        }
        return null;
    }

    @Override
    public boolean canAccept(IEntity iEntity) {
        return iEntity instanceof Item || iEntity instanceof Corpse;
    }

    static {
        keyEventMapping.put(49, 1);
        keyEventMapping.put(50, 2);
        keyEventMapping.put(51, 3);
        keyEventMapping.put(52, 4);
        keyEventMapping.put(53, 5);
        keyEventMapping.put(54, 6);
        keyEventMapping.put(55, 7);
        keyEventMapping.put(56, 8);
        keyEventMapping.put(57, 9);
        keyEventMapping.put(48, 10);
        globalEffects = new LinkedList<EffectLayer>();
        offlineIcon = SpriteStore.get().getSprite("data/gui/offline.png");
    }
}

