/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteCache;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.util.JSONLoader;
import games.stendhal.common.Outfits;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class OutfitStore {
    private Logger logger = Logger.getLogger(OutfitStore.class);
    private static final String OUTFITS = "data/sprites/outfit";
    final List<String> emptyForZeroIndex = Arrays.asList("dress", "mouth", "mask", "hair", "hat", "detail");
    private List<Integer> detailRearLayers;
    private boolean initialized = false;
    private static final OutfitStore sharedInstance = new OutfitStore(SpriteStore.get());
    private SpriteStore store;

    private OutfitStore(SpriteStore spriteStore) {
        this.store = spriteStore;
        this.detailRearLayers = new ArrayList<Integer>();
    }

    public void init() {
        if (this.initialized) {
            this.logger.warn((Object)"tried to re-initialize OutfitStore");
            return;
        }
        this.initialized = true;
        final JSONLoader jSONLoader = new JSONLoader();
        jSONLoader.onDataReady = new Runnable(){

            @Override
            public void run() {
                JSONObject jSONObject = (JSONObject)jSONLoader.data;
                JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject.get((Object)"detail")).get((Object)"rear");
                for (Object e : jSONArray) {
                    try {
                        OutfitStore.this.detailRearLayers.add(Integer.parseInt(e.toString()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        OutfitStore.this.logger.error((Object)("Couldn't parse rear detail layer \"" + e.toString() + "\""), (Throwable)numberFormatException);
                    }
                }
            }
        };
        jSONLoader.load("data/sprites/outfit/outfits.json");
    }

    private boolean detailHasRearLayer(int n) {
        return this.detailRearLayers.contains(n);
    }

    private Sprite buildOutfit(String string, OutfitColor outfitColor) {
        Sprite sprite;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(Outfits.LAYER_NAMES);
        for (String string2 : linkedList) {
            hashMap.put(string2, 0);
        }
        for (String string3 : string.split(",")) {
            if (!string3.contains("=")) continue;
            String[] stringArray = string3.split("=");
            hashMap.put(stringArray[0], Integer.parseInt(stringArray[1]));
        }
        int n = (Integer)hashMap.get("detail");
        if (this.detailHasRearLayer(n)) {
            linkedList.add(0, "detail-rear");
            hashMap.put("detail-rear", n);
        }
        int n2 = (Integer)hashMap.get("body");
        boolean bl = false;
        if (n2 < 0) {
            sprite = this.store.getEmptySprite(144, 256);
        } else {
            sprite = this.getLayerSprite("body", (int)((Integer)hashMap.get("body")), outfitColor);
            if (n2 >= 0 && n2 <= 2) {
                bl = true;
            }
        }
        if (sprite == null) {
            throw new IllegalArgumentException("No body image found for outfit: " + hashMap.get("body"));
        }
        ImageSprite imageSprite = new ImageSprite(sprite);
        Graphics graphics = imageSprite.getGraphics();
        for (String string4 : linkedList) {
            if (string4.equals("hair") && Outfits.HATS_NO_HAIR.contains(hashMap.get("hat"))) continue;
            boolean bl2 = Outfits.SHIPS_NO_LAYERS.contains(hashMap.get("body"));
            if (string4.equals("dress") && bl2 || string4.equals("head") && bl2 || string4.equals("mouth") && bl2 || string4.equals("eyes") && bl2 || string4.equals("hair") && bl2 || string4.equals("mask") && bl2 || string4.equals("hat") && bl2 || string4.equals("detail") && bl2) continue;
            sprite = Outfits.RECOLORABLE_OUTFIT_PARTS.contains(string4) ? this.getLayerSprite(string4, (Integer)hashMap.get(string4), outfitColor, bl) : this.getLayerSprite(string4, (int)((Integer)hashMap.get(string4)), bl);
            sprite.draw(graphics, 0, 0);
        }
        return imageSprite;
    }

    public static OutfitStore get() {
        return sharedInstance;
    }

    private String getSpriteSuffix(int n) {
        String string = n < 10 ? "00" + Integer.toString(n) : (n < 100 ? "0" + Integer.toString(n) : Integer.toString(n));
        return string;
    }

    private Sprite getEmptySprite() {
        return this.store.getEmptySprite();
    }

    public Sprite getLayerSprite(String string, int n, OutfitColor outfitColor, boolean bl) {
        Object object;
        if (this.emptyForZeroIndex.contains(string) ? n <= 0 : n < 0) {
            return this.getEmptySprite();
        }
        String string2 = this.getSpriteSuffix(n);
        if (string.endsWith("-rear")) {
            string2 = string2 + "-rear";
            string = string.replaceFirst("-rear$", "");
        }
        string2 = "data/sprites/outfit/" + string + "/" + string2;
        if (string.equals("body") && WtWindowManager.getInstance().getPropertyBoolean("gamescreen.nonude", true)) {
            object = DataLoader.getResource(string2 + "-nonude.png");
            if (object != null) {
                string2 = string2 + "-nonude";
            }
        } else if (string.equals("dress") && bl && (object = DataLoader.getResource(string2 + "s.png")) != null) {
            string2 = string2 + "s";
        }
        string2 = string2 + ".png";
        if (outfitColor == null) {
            return this.store.getSprite(string2);
        }
        List<String> list = Arrays.asList("body", "head");
        object = list.contains(string) ? "skin" : string;
        return this.store.getColoredSprite(string2, outfitColor.getColor((String)object));
    }

    public Sprite getLayerSprite(String string, int n, OutfitColor outfitColor) {
        return this.getLayerSprite(string, n, outfitColor, false);
    }

    public Sprite getLayerSprite(String string, int n, boolean bl) {
        return this.getLayerSprite(string, n, null, bl);
    }

    public Sprite getLayerSprite(String string, int n) {
        return this.getLayerSprite(string, n, null, false);
    }

    public Sprite getFailsafeOutfit() {
        try {
            return this.getOutfit("body=0,dress=0,head=0,mouth=0,eyes=0,mask=0,hair=0,hat=0,detail=0", OutfitColor.PLAIN);
        }
        catch (RuntimeException runtimeException) {
            this.logger.warn((Object)"Cannot build failsafe outfit. Trying to use standard failsafe sprite.", (Throwable)runtimeException);
            return this.store.getFailsafe();
        }
    }

    private Sprite getOutfit(String string, OutfitColor outfitColor) {
        String string2 = "null";
        if (outfitColor != null) {
            string2 = outfitColor.toString();
        }
        String string3 = this.buildReference(string, string2);
        return this.getOutfit(string, outfitColor, string3);
    }

    private Sprite getOutfit(String string, OutfitColor outfitColor, String string2) {
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite = null;
        if (sprite == null) {
            sprite = this.buildOutfit(string, outfitColor);
            spriteCache.add(string2, sprite);
        }
        return sprite;
    }

    public Sprite getAdjustedOutfit(String string, OutfitColor outfitColor, Color color, Composite composite) {
        if (color == null || composite == null) {
            return this.getOutfit(string, outfitColor);
        }
        String string2 = this.buildReference(string, outfitColor.toString());
        String string3 = string2 + ":" + color.getRGB() + composite.toString();
        Sprite sprite = null;
        if (sprite == null) {
            Sprite sprite2 = this.getOutfit(string, outfitColor);
            sprite = this.store.modifySprite(sprite2, color, composite, string3);
        }
        return sprite;
    }

    private String buildReference(String string, String string2) {
        return "OUTFIT:" + string + "@" + string2;
    }
}

