/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.LayerRenderer;
import games.stendhal.client.Zone;
import games.stendhal.client.ZoneInfo;
import games.stendhal.common.CollisionDetection;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import org.apache.log4j.Logger;

public class StaticGameLayers {
    private static final Logger logger = Logger.getLogger(StaticGameLayers.class);
    private String area = null;
    private final ZoneInfo zoneInfo = ZoneInfo.get();
    private Zone currentZone;

    public double getDangerLevel() {
        return this.currentZone.getDangerLevel();
    }

    public double getWidth() {
        if (this.currentZone != null) {
            return this.currentZone.getWidth();
        }
        return 0.0;
    }

    public double getHeight() {
        if (this.currentZone != null) {
            return this.currentZone.getHeight();
        }
        return 0.0;
    }

    public void setZone(Zone zone) {
        this.currentZone = zone;
        if (!zone.getName().equals(this.area)) {
            this.setAreaName(zone.getName());
        }
    }

    boolean collides(Rectangle2D rectangle2D) {
        if (this.currentZone != null) {
            return this.currentZone.collides(rectangle2D);
        }
        return false;
    }

    void clear() {
        this.zoneInfo.zoneChanged();
    }

    private void setAreaName(String string) {
        this.area = string;
    }

    public String getAreaName() {
        return this.area;
    }

    public String getReadableName() {
        return this.currentZone.getReadableName();
    }

    void drawLayers(Graphics graphics, String string, String string2, int n, int n2, int n3, int n4, String string3, String ... stringArray) {
        LayerRenderer layerRenderer = this.getMerged(string, string2, string3, stringArray);
        if (layerRenderer != null) {
            layerRenderer.draw(graphics, n, n2, n3, n4);
        }
    }

    void drawWeather(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.currentZone != null && this.currentZone.getName().equals(this.area)) {
            this.currentZone.getWeather().draw(graphics, n, n2, n3, n4);
        }
    }

    private LayerRenderer getMerged(String string, String string2, String string3, String ... stringArray) {
        if (this.currentZone != null) {
            if (this.currentZone.getName().equals(string)) {
                return this.currentZone.getMerged(string2, string3, stringArray);
            }
            logger.warn((Object)("Trying to draw zone: " + string + ", but the current zone is: " + this.currentZone.getName()));
        }
        return null;
    }

    public CollisionDetection getCollisionDetection() {
        if (this.currentZone != null) {
            return this.currentZone.getCollision();
        }
        return null;
    }

    public CollisionDetection getProtectionDetection() {
        if (this.currentZone != null) {
            return this.currentZone.getProtection();
        }
        return null;
    }

    public CollisionDetection getSecretDetection() {
        if (this.currentZone != null) {
            return this.currentZone.getSecret();
        }
        return null;
    }
}

