/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import java.util.ArrayList;
import java.util.List;

public enum UiRenderingMethod {
    DEFAULT(""),
    DIRECT_DRAW("directdraw"),
    DDRAW_HWSCALE("hw_scale"),
    SOFTWARE("software"),
    OPEN_GL("opengl"),
    XRENDER("xrender"),
    METAL("metal");

    private final String propertyValue;

    private UiRenderingMethod(String string2) {
        this.propertyValue = string2;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public static UiRenderingMethod fromPropertyValue(String string) {
        for (UiRenderingMethod uiRenderingMethod : UiRenderingMethod.values()) {
            if (!string.equals(uiRenderingMethod.getPropertyValue())) continue;
            return uiRenderingMethod;
        }
        return null;
    }

    public static List<UiRenderingMethod> getAvailableMethods() {
        ArrayList<UiRenderingMethod> arrayList = new ArrayList<UiRenderingMethod>();
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            arrayList.add(DEFAULT);
            arrayList.add(DIRECT_DRAW);
            arrayList.add(DDRAW_HWSCALE);
            arrayList.add(SOFTWARE);
            arrayList.add(OPEN_GL);
        } else if (string.startsWith("mac os")) {
            arrayList.add(DEFAULT);
            arrayList.add(SOFTWARE);
            arrayList.add(OPEN_GL);
            arrayList.add(METAL);
        } else {
            arrayList.add(DEFAULT);
            arrayList.add(SOFTWARE);
            arrayList.add(OPEN_GL);
            arrayList.add(XRENDER);
        }
        return arrayList;
    }
}

