/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.ObjectChangeListener;
import games.stendhal.client.gui.buddies.BuddyPanelController;
import games.stendhal.client.gui.stats.KarmaIndicator;
import games.stendhal.client.gui.stats.ManaIndicator;
import games.stendhal.client.gui.stats.StatsPanelController;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import marauroa.common.game.RPEvent;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;

class UserController
implements ObjectChangeListener {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public UserController() {
        this.pcs.addPropertyChangeListener("buddies", BuddyPanelController.get());
        this.pcs.addPropertyChangeListener("features", KarmaIndicator.get());
        this.pcs.addPropertyChangeListener("features", ManaIndicator.get());
        StatsPanelController statsPanelController = StatsPanelController.get();
        statsPanelController.registerListeners(this.pcs);
    }

    @Override
    public void deleted() {
        for (PropertyChangeListener propertyChangeListener : this.pcs.getPropertyChangeListeners()) {
            propertyChangeListener.propertyChange(null);
        }
    }

    @Override
    public void modifiedAdded(RPObject rPObject) {
        for (String object : rPObject) {
            this.pcs.firePropertyChange(object, null, rPObject.get(object));
        }
        for (RPEvent rPEvent : rPObject.events()) {
            this.pcs.firePropertyChange(rPEvent.getName(), null, rPEvent);
        }
        for (RPSlot rPSlot : rPObject.slots()) {
            this.pcs.firePropertyChange(rPSlot.getName(), null, rPSlot);
        }
        for (Map.Entry entry : rPObject.maps().entrySet()) {
            this.pcs.firePropertyChange((String)entry.getKey(), null, entry.getValue());
        }
    }

    @Override
    public void modifiedDeleted(RPObject rPObject) {
        for (String object : rPObject) {
            this.pcs.firePropertyChange(object, rPObject.get(object), null);
        }
        for (RPEvent rPEvent : rPObject.events()) {
            this.pcs.firePropertyChange(rPEvent.getName(), rPEvent, null);
        }
        for (RPSlot rPSlot : rPObject.slots()) {
            this.pcs.firePropertyChange(rPSlot.getName(), rPSlot, null);
        }
        for (Map.Entry entry : rPObject.maps().entrySet()) {
            this.pcs.firePropertyChange((String)entry.getKey(), entry.getValue(), null);
        }
    }
}

