/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.StendhalClient;
import games.stendhal.client.Zone;
import games.stendhal.client.sound.facade.InfiniteAudibleArea;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.SoundHandle;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.common.constants.SoundLayer;
import java.util.Objects;

public class WeatherSoundManager
implements StendhalClient.ZoneChangeListener {
    private static final String SOUND_LOCATION = "weather/";
    private String soundName;
    private SoundHandle currentSound;
    private final Time fadeOutDuration = new Time(2L, Time.Unit.SEC);
    private final Time fadeInDuration = new Time();

    @Override
    public void onZoneChange(Zone zone) {
    }

    @Override
    public void onZoneUpdate(Zone zone) {
        this.updateWeatherSound(zone.getWeatherName());
    }

    @Override
    public void onZoneChangeCompleted(Zone zone) {
        this.updateWeatherSound(zone.getWeatherName());
    }

    private void updateWeatherSound(String string) {
        if (!Objects.equals(string, this.soundName)) {
            if (this.currentSound != null) {
                ClientSingletonRepository.getSound().stop(this.currentSound, this.fadeOutDuration);
                this.currentSound = null;
            }
            this.soundName = string;
            if (string != null) {
                SoundGroup soundGroup;
                String string2 = SOUND_LOCATION + string + ".ogg";
                if (this.getClass().getResource("/data/sounds/" + string2) != null && (soundGroup = ClientSingletonRepository.getSound().getGroup(SoundLayer.AMBIENT_SOUND.groupName)).loadSound(string, string2, SoundFileType.OGG, true)) {
                    InfiniteAudibleArea infiniteAudibleArea = new InfiniteAudibleArea();
                    this.currentSound = soundGroup.play(string, 0, infiniteAudibleArea, this.fadeInDuration, true, false);
                }
            }
        }
    }
}

