/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.actions;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.actions.SlashAction;
import games.stendhal.client.gui.UserInterface;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.chatlog.StandardEventLine;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.common.NotificationType;
import games.stendhal.common.math.Numeric;

class VolumeAction
implements SlashAction {
    VolumeAction() {
    }

    @Override
    public boolean execute(String[] stringArray, String string) {
        if (stringArray[0] == null) {
            float f = ClientSingletonRepository.getSound().getVolume();
            UserInterface userInterface = ClientSingletonRepository.getUserInterface();
            userInterface.addEventLine(new StandardEventLine("U\u017cyj /volume <nazwa> <warto\u015b\u0107>, aby regulowa\u0107 poziom g\u0142o\u015bno\u015bci."));
            userInterface.addEventLine(new HeaderLessEventLine("<nazwa> jest to pozycja z poni\u017cszej listy. \"master\" przedstawia g\u0142obalne ustawienia g\u0142o\u015bno\u015bci.", NotificationType.CLIENT));
            userInterface.addEventLine(new HeaderLessEventLine("<warto\u015b\u0107> jest z zakresu od 0 do 100, ale mo\u017ce by\u0107 ustawiona wy\u017csza.", NotificationType.CLIENT));
            userInterface.addEventLine(new HeaderLessEventLine("master -> " + Numeric.floatToInt(f, 100.0f), NotificationType.CLIENT));
            for (String string2 : ClientSingletonRepository.getSound().getGroupNames()) {
                f = ClientSingletonRepository.getSound().getGroup(string2).getVolume();
                userInterface.addEventLine(new HeaderLessEventLine(string2 + " -> " + Numeric.floatToInt(f, 100.0f), NotificationType.CLIENT));
            }
        } else if (stringArray[1] != null) {
            this.changeVolume(stringArray[0], stringArray[1]);
        } else {
            ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine("U\u017cyj /volume dla pomocy.", NotificationType.ERROR));
        }
        return true;
    }

    private void changeVolume(String string, String string2) {
        try {
            boolean bl = false;
            for (String object : ClientSingletonRepository.getSound().getGroupNames()) {
                if (!object.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                int n = Integer.parseInt(string2);
                SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(string);
                soundGroup.changeVolume(Numeric.intToFloat(n, 100.0f));
                WtWindowManager.getInstance().setProperty("sound.volume." + string, Integer.toString(n));
            } else if (string.equals("master")) {
                int n = Integer.parseInt(string2);
                ClientSingletonRepository.getSound().changeVolume(Numeric.intToFloat(n, 100.0f));
                WtWindowManager.getInstance().setProperty("sound.volume." + string, Integer.toString(n));
            } else {
                ClientSingletonRepository.getUserInterface().addEventLine(new StandardEventLine("Nie istnieje \u017cadna grupa d\u017awi\u0119ku \"" + string + "\""));
                ClientSingletonRepository.getUserInterface().addEventLine(new StandardEventLine("Wpisz \"/volume show\", aby zobaczy\u0107 list\u0119 grup"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(string2 + " nie jest prawid\u0142owym numerem", NotificationType.ERROR));
        }
    }

    @Override
    public int getMaximumParameters() {
        return 2;
    }

    @Override
    public int getMinimumParameters() {
        return 0;
    }
}

