/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.GameObjects;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.Property;
import games.stendhal.common.Direction;
import marauroa.common.game.RPObject;

public abstract class ActiveEntity
extends Entity {
    private static final double EPSILON = 0.001;
    public static final Property PROP_DIRECTION = new Property();
    public static final Property PROP_SPEED = new Property();
    private Direction direction = Direction.DOWN;
    private double dx;
    private double dy;
    private boolean flying = false;

    ActiveEntity() {
        this.setSpeed(0.0, 0.0);
    }

    public Direction getDirection() {
        return this.direction;
    }

    void setDirection(Direction direction) {
        boolean bl = this.direction != direction;
        this.direction = direction;
        if (bl) {
            this.fireChange(PROP_DIRECTION);
        }
    }

    public boolean stopped() {
        return this.dx == 0.0 && this.dy == 0.0;
    }

    private static boolean compareDouble(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    private static double calcDeltaMovement(double d, double d2, double d3) {
        double d4 = d - d2;
        double d5 = (d3 - d4) / d3;
        return (d3 + d3 * d5) / 2.0;
    }

    private void onMove(int n, int n2, Direction direction, double d) {
        double d2 = this.x;
        double d3 = this.y;
        this.setSpeed((double)direction.getdx() * d, (double)direction.getdy() * d);
        if (Direction.LEFT == direction || Direction.RIGHT == direction) {
            this.y = n2;
            if (ActiveEntity.compareDouble(this.x, n, 1.0)) {
                this.dx = ActiveEntity.calcDeltaMovement(this.x + this.dx * 0.1, n, direction.getdx()) * d;
            } else {
                this.x = n;
            }
            this.dy = 0.0;
        } else if (Direction.UP == direction || Direction.DOWN == direction) {
            this.x = n;
            this.dx = 0.0;
            if (ActiveEntity.compareDouble(this.y, n2, 1.0)) {
                this.dy = ActiveEntity.calcDeltaMovement(this.y + this.dy * 0.1, n2, direction.getdy()) * d;
            } else {
                this.y = n2;
            }
        } else {
            this.x = n;
            this.y = n2;
        }
        if (!(ActiveEntity.compareDouble(this.x, d2, 0.001) && ActiveEntity.compareDouble(this.y, d3, 0.001) && ActiveEntity.compareDouble(d2, (int)d2, 0.001) && ActiveEntity.compareDouble(d3, (int)d3, 0.001))) {
            this.onPosition(n, n2);
        }
    }

    @Override
    public void initialize(RPObject rPObject) {
        super.initialize(rPObject);
        if (rPObject.has("dir")) {
            this.setDirection(Direction.build(rPObject.getInt("dir")));
        }
        double d = rPObject.has("speed") ? rPObject.getDouble("speed") : 0.0;
        if (rPObject.has("flying")) {
            this.flying = true;
        }
        this.dx = (double)this.direction.getdx() * d;
        this.dy = (double)this.direction.getdy() * d;
    }

    @Override
    public void update(int n) {
        super.update(n);
        if (!this.stopped()) {
            double d = (double)n / 300.0;
            double d2 = this.x;
            double d3 = this.y;
            this.x += this.dx * d;
            this.y += this.dy * d;
            if (GameObjects.getInstance().collides(this)) {
                this.x = d2;
                this.y = d3;
            } else {
                this.onPosition(this.x, this.y);
            }
        }
    }

    @Override
    protected void processPositioning(RPObject rPObject, RPObject rPObject2) {
        double d;
        Direction direction;
        int n = rPObject.getInt("x");
        int n2 = rPObject.getInt("y");
        int n3 = n;
        int n4 = n2;
        if (rPObject2.has("x")) {
            n3 = rPObject2.getInt("x");
        }
        if (rPObject2.has("y")) {
            n4 = rPObject2.getInt("y");
        }
        if (rPObject2.has("dir")) {
            direction = Direction.build(rPObject2.getInt("dir"));
            this.setDirection(direction);
        } else if (rPObject.has("dir")) {
            direction = Direction.build(rPObject.getInt("dir"));
            this.setDirection(direction);
        } else {
            direction = Direction.STOP;
        }
        boolean bl = false;
        if (rPObject2.has("speed")) {
            d = rPObject2.getDouble("speed");
            bl = true;
        } else {
            d = rPObject.has("speed") ? rPObject.getDouble("speed") : 0.0;
        }
        this.onMove(n3, n4, direction, d);
        if (bl) {
            this.fireChange(PROP_SPEED);
        }
        boolean bl2 = false;
        if (Direction.STOP == direction || d == 0.0) {
            this.setSpeed(0.0, 0.0);
            if (!ActiveEntity.compareDouble(this.y, n4, 0.001) || !ActiveEntity.compareDouble(this.x, n3, 0.001)) {
                bl2 = true;
            }
            this.x = n3;
            this.y = n4;
        }
        if (bl2 || n != n3 && n2 != n4) {
            this.onPosition(n3, n4);
        }
    }

    final void setSpeed(double d, double d2) {
        this.dx = d;
        this.dy = d2;
    }

    public boolean isFlying() {
        return this.flying;
    }
}

