/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.entity.NPC;
import games.stendhal.client.entity.Property;
import games.stendhal.common.constants.SoundLayer;
import marauroa.common.game.RPObject;

public abstract class DomesticAnimal
extends NPC {
    public static final Property PROP_WEIGHT = new Property();
    private int weight;

    public int getWeight() {
        return this.weight;
    }

    @Override
    public void initialize(RPObject rPObject) {
        super.initialize(rPObject);
        this.addSounds(SoundLayer.CREATURE_NOISE.groupName, "eat", "eat-01");
        this.weight = rPObject.has("weight") ? rPObject.getInt("weight") : 0;
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        super.onChangedAdded(rPObject, rPObject2);
        if (rPObject2.has("weight")) {
            int n = this.weight;
            this.weight = rPObject2.getInt("weight");
            if (this.weight > n) {
                this.playRandomSoundFromCategory(SoundLayer.CREATURE_NOISE.groupName, "eat");
            }
            this.fireChange(PROP_WEIGHT);
        }
    }
}

