/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.entity.ContentChangeListener;
import games.stendhal.client.entity.EntityChangeListener;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Property;
import games.stendhal.client.listener.RPObjectChangeListener;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;

public class Entity
implements RPObjectChangeListener,
IEntity {
    protected double x = 0.0;
    protected double y = 0.0;
    private int resistance;
    private boolean walkBlocker = false;
    private int visibility;
    private final List<EntityChangeListener<? extends IEntity>> changeListeners = new CopyOnWriteArrayList<EntityChangeListener<? extends IEntity>>();
    private final List<ContentChangeListener> contentChangeListeners = new CopyOnWriteArrayList<ContentChangeListener>();
    protected RPObject rpObject;
    protected String clazz = null;
    protected String name = null;
    private String subclazz = null;
    protected String title = null;
    protected String type = null;
    protected boolean inAdd;
    private double width;
    private double height;
    private Rectangle2D.Double area;

    @Override
    public void addChangeListener(EntityChangeListener<?> entityChangeListener) {
        this.changeListeners.add(entityChangeListener);
    }

    @Override
    public void addContentChangeListener(ContentChangeListener contentChangeListener) {
        this.contentChangeListeners.add(contentChangeListener);
    }

    @Override
    public void removeContentChangeListener(ContentChangeListener contentChangeListener) {
        this.contentChangeListeners.remove(contentChangeListener);
    }

    public void fireChange(Property property) {
        for (EntityChangeListener<? extends IEntity> entityChangeListener : this.changeListeners) {
            entityChangeListener.entityChanged(this, property);
        }
    }

    @Override
    public boolean isUser() {
        return false;
    }

    @Override
    public Rectangle2D getArea() {
        if (this.area == null) {
            this.area = new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        } else {
            this.area.x = this.getX();
            this.area.y = this.getY();
            this.area.width = this.getWidth();
            this.area.height = this.getHeight();
        }
        return this.area;
    }

    @Override
    public int getVisibility() {
        return this.visibility;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public final RPObject.ID getID() {
        if (this.rpObject == null) {
            return null;
        }
        return this.rpObject.getID();
    }

    public final int getObjectID() {
        if (this.rpObject == null) {
            return -1;
        }
        return this.rpObject.getInt("id");
    }

    @Override
    public String getEntityClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEntitySubclass() {
        return this.subclazz;
    }

    @Override
    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.name != null) {
            return this.name;
        }
        if (this.type != null) {
            return this.type;
        }
        return null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public RPObject getRPObject() {
        return this.rpObject;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public boolean isOnGround() {
        return !this.rpObject.isContained();
    }

    protected void processPositioning(RPObject rPObject, RPObject rPObject2) {
        int n;
        boolean bl = false;
        if (rPObject2.has("x") && (double)(n = rPObject2.getInt("x")) != this.x) {
            this.x = n;
            bl = true;
        }
        if (rPObject2.has("y") && (double)(n = rPObject2.getInt("y")) != this.y) {
            this.y = n;
            bl = true;
        }
        if (bl) {
            this.onPosition(this.x, this.y);
        }
    }

    protected void onPosition(double d, double d2) {
        this.fireChange(PROP_POSITION);
    }

    @Override
    public int getResistance() {
        return this.resistance;
    }

    @Override
    public int getResistance(IEntity iEntity) {
        return this.getResistance() * iEntity.getResistance() / 100;
    }

    @Override
    public RPSlot getSlot(String string) {
        if (this.rpObject.hasSlot(string)) {
            return this.rpObject.getSlot(string);
        }
        return null;
    }

    @Override
    public void initialize(RPObject rPObject) {
        this.rpObject = rPObject;
        this.clazz = rPObject.has("class") ? rPObject.get("class") : null;
        this.name = rPObject.has("name") ? rPObject.get("name") : null;
        this.subclazz = rPObject.has("subclass") ? rPObject.get("subclass") : null;
        this.height = rPObject.has("height") ? rPObject.getDouble("height") : 1.0;
        this.width = rPObject.has("width") ? rPObject.getDouble("width") : 1.0;
        this.title = rPObject.has("title") ? rPObject.get("title") : null;
        this.resistance = rPObject.has("resistance") ? rPObject.getInt("resistance") : 0;
        if (rPObject.has("walk_blocker")) {
            this.walkBlocker = true;
        }
        this.visibility = rPObject.has("visibility") ? rPObject.getInt("visibility") : 100;
        this.x = rPObject.has("x") ? (double)rPObject.getInt("x") : 0.0;
        this.y = rPObject.has("y") ? (double)rPObject.getInt("y") : 0.0;
        this.onPosition(this.x, this.y);
        this.type = rPObject.getRPClass().getName();
        this.inAdd = true;
        this.onChangedAdded(new RPObject(), rPObject);
        this.inAdd = false;
    }

    @Override
    public boolean isObstacle(IEntity iEntity) {
        if (this.walkBlocker) {
            return true;
        }
        return iEntity != this && this.getResistance(iEntity) > 95;
    }

    @Override
    public void release() {
    }

    @Override
    public void removeChangeListener(EntityChangeListener<?> entityChangeListener) {
        this.changeListeners.remove(entityChangeListener);
    }

    @Override
    public void update(int n) {
    }

    @Override
    public final void onAdded(RPObject rPObject) {
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        if (this.inAdd) {
            return;
        }
        if (rPObject2.has("class")) {
            this.clazz = rPObject2.get("class");
            this.fireChange(PROP_CLASS);
        }
        if (rPObject2.has("name")) {
            this.name = rPObject2.get("name");
            this.fireChange(PROP_NAME);
            this.fireChange(PROP_TITLE);
        }
        if (rPObject2.has("subclass")) {
            this.subclazz = rPObject2.get("subclass");
            this.fireChange(PROP_CLASS);
        }
        boolean bl = false;
        if (rPObject2.has("width")) {
            this.width = rPObject2.getDouble("width");
            bl = true;
        }
        if (rPObject2.has("height")) {
            this.height = rPObject2.getDouble("height");
            bl = true;
        }
        if (bl) {
            this.fireChange(PROP_SIZE);
        }
        if (rPObject2.has("title")) {
            this.title = rPObject2.get("title");
            this.fireChange(PROP_TITLE);
        }
        if (rPObject2.has("state")) {
            this.fireChange(PROP_STATE);
        }
        if (rPObject2.has("resistance")) {
            this.resistance = rPObject2.getInt("resistance");
        }
        if (rPObject2.has("visibility")) {
            this.visibility = rPObject2.getInt("visibility");
            this.fireChange(PROP_VISIBILITY);
        }
        for (RPSlot rPSlot : rPObject2.slots()) {
            for (ContentChangeListener contentChangeListener : this.contentChangeListeners) {
                contentChangeListener.contentAdded(rPSlot);
            }
        }
        this.processPositioning(rPObject, rPObject2);
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        if (rPObject2.has("class")) {
            this.clazz = null;
            this.fireChange(PROP_CLASS);
        }
        if (rPObject2.has("name")) {
            this.name = null;
            this.fireChange(PROP_NAME);
            this.fireChange(PROP_TITLE);
        }
        if (rPObject2.has("subclass")) {
            this.subclazz = null;
            this.fireChange(PROP_CLASS);
        }
        boolean bl = false;
        if (rPObject2.has("width")) {
            this.width = 1.0;
            bl = true;
        }
        if (rPObject2.has("height")) {
            this.height = 1.0;
            bl = true;
        }
        if (bl) {
            this.fireChange(PROP_SIZE);
        }
        if (rPObject2.has("title")) {
            this.title = null;
            this.fireChange(PROP_TITLE);
        }
        if (rPObject2.has("resistance")) {
            this.resistance = 0;
        }
        if (rPObject2.has("visibility")) {
            this.visibility = 100;
            this.fireChange(PROP_VISIBILITY);
        }
        for (RPSlot rPSlot : rPObject2.slots()) {
            for (ContentChangeListener contentChangeListener : this.contentChangeListeners) {
                contentChangeListener.contentRemoved(rPSlot);
            }
        }
    }

    @Override
    @Deprecated
    public final void onRemoved(RPObject rPObject) {
    }

    @Override
    public void onSlotAdded(RPObject rPObject, String string, RPObject rPObject2) {
    }

    @Override
    public void onSlotChangedAdded(RPObject rPObject, String string, RPObject rPObject2, RPObject rPObject3) {
    }

    @Override
    public void onSlotChangedRemoved(RPObject rPObject, String string, RPObject rPObject2, RPObject rPObject3) {
    }

    @Override
    public void onSlotRemoved(RPObject rPObject, String string, RPObject rPObject2) {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        if (this.rpObject != null && this.rpObject.has("name")) {
            stringBuilder.append('[');
            stringBuilder.append(this.rpObject.get("name"));
            stringBuilder.append(']');
        }
        stringBuilder.append('@');
        stringBuilder.append(System.identityHashCode(this));
        return stringBuilder.toString();
    }

    @Override
    public String getCursor() {
        if (!this.rpObject.has("cursor")) {
            return null;
        }
        return this.rpObject.get("cursor");
    }

    @Override
    public List<String> getPath() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (RPObject rPObject = this.getRPObject(); rPObject != null; rPObject = rPObject.getContainer()) {
            linkedList.add(0, Integer.toString(rPObject.getID().getObjectID()));
            RPSlot rPSlot = rPObject.getContainerSlot();
            if (rPSlot == null) continue;
            linkedList.add(0, rPSlot.getName());
        }
        return linkedList;
    }
}

